/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.feature;

import fluke.stygian.block.ModBlocks;
import fluke.stygian.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenEnderCanopy
extends WorldGenAbstractTree {
    protected static final IBlockState LOG = ModBlocks.endLog.func_176223_P();
    protected static final IBlockState LEAF = ModBlocks.endLeaves.func_176223_P();
    private static final IBlockState END_GRASS = ModBlocks.endGrass.func_176223_P();

    public WorldGenEnderCanopy(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int trunkHeight;
        IBlockState inState = world.func_180495_p(pos);
        if (inState != END_GRASS && inState != Blocks.field_150377_bs.func_176223_P()) {
            pos = pos.func_177977_b();
        }
        if (!this.isValidGenLocation(world, pos, trunkHeight = 16 + rand.nextInt(4))) {
            return false;
        }
        this.buildTrunk(world, rand, pos, trunkHeight);
        List<BranchInfo> branchEndPos = this.buildBranches(world, rand, pos, trunkHeight);
        this.buildCanopy(world, rand, pos, branchEndPos);
        return true;
    }

    public boolean isValidGenLocation(World world, BlockPos pos, int trunkHeight) {
        if (pos.func_177956_o() < 3 || pos.func_177956_o() + trunkHeight + 22 > 255) {
            return false;
        }
        for (BlockPos trunkBaseBlock : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-5, 0, -5), (BlockPos)pos.func_177982_a(5, 2, 5))) {
            IBlockState state = world.func_180495_p(trunkBaseBlock);
            if (state == END_GRASS || state == Blocks.field_150377_bs.func_176223_P() || state.func_177230_c() == ModBlocks.endCanopySapling || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || this.isReplaceable(world, trunkBaseBlock, state)) continue;
            return false;
        }
        for (BlockPos trunkCoreBlock : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 3, -1), (BlockPos)pos.func_177982_a(1, trunkHeight - 1, 3))) {
            if (this.isReplaceable(world, trunkCoreBlock)) continue;
            return false;
        }
        for (BlockPos canopyBlock : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-23, trunkHeight + 7, -23), (BlockPos)pos.func_177982_a(23, trunkHeight + 7, 23))) {
            if (this.isReplaceable(world, canopyBlock)) continue;
            return false;
        }
        return true;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.isReplaceable(world, pos, state);
    }

    private boolean isReplaceable(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c());
    }

    private void buildCanopy(World world, Random rand, BlockPos pos, List<BranchInfo> branchEnds) {
        ArrayList<BlockPos> possibleVineSpots = new ArrayList<BlockPos>();
        for (BranchInfo branch : branchEnds) {
            double xAngleTranslation = Math.cos(Math.toRadians(branch.rotationAngle));
            double zAngleTranslation = Math.sin(Math.toRadians(branch.rotationAngle));
            int xAnglizer = (int)Math.round(1.0 * xAngleTranslation);
            int zAnglizer = (int)Math.round(1.0 * zAngleTranslation);
            for (int y = 0; y <= 2; ++y) {
                int canopyRadius = 8;
                if (y == 0) {
                    canopyRadius -= 3;
                } else if (y == 2) {
                    canopyRadius -= 2;
                }
                int maxDist = canopyRadius * canopyRadius;
                int lesserMaxDist = (canopyRadius - 1) * canopyRadius;
                for (int x = -canopyRadius; x <= canopyRadius; ++x) {
                    for (int z = -canopyRadius; z <= canopyRadius; ++z) {
                        int distortedMaxDistance;
                        double xDist = x * x;
                        double zDist = z * z;
                        double ratio = Math.abs(x) > Math.abs(z) ? (double)(z * zAnglizer) / ((double)(x * xAnglizer) + 0.001) : (double)(x * xAnglizer) / ((double)(z * zAnglizer) + 0.001);
                        double squishFactor = MathHelper.func_151238_b((double)1.0, (double)1.55, (double)(ratio = 1.0 - (ratio + 1.0) / 2.0));
                        if (!((xDist *= squishFactor) + (zDist *= squishFactor) < (double)(distortedMaxDistance = rand.nextBoolean() ? lesserMaxDist : maxDist))) continue;
                        this.placeLeafAt(world, branch.endPoint.func_177982_a(x, y, z));
                        if (y >= 2 || !(xDist + zDist > (double)lesserMaxDist) || rand.nextInt(4) != 0) continue;
                        possibleVineSpots.add(branch.endPoint.func_177982_a(x, y, z));
                    }
                }
            }
        }
        for (BlockPos vinePos : possibleVineSpots) {
            this.placeVine(world, rand, vinePos);
        }
    }

    private void placeVine(World world, Random rand, BlockPos pos) {
        int length = rand.nextInt(22);
        int vineChance = rand.nextInt(1);
        if (vineChance == 0) {
            if (world.func_175623_d(pos.func_177976_e())) {
                this.addHangingVine(world, pos.func_177976_e(), BlockVine.field_176278_M, length);
            }
            if (world.func_175623_d(pos.func_177974_f())) {
                this.addHangingVine(world, pos.func_177974_f(), BlockVine.field_176280_O, length);
            }
            if (world.func_175623_d(pos.func_177978_c())) {
                this.addHangingVine(world, pos.func_177978_c(), BlockVine.field_176279_N, length);
            }
            if (world.func_175623_d(pos.func_177968_d())) {
                this.addHangingVine(world, pos.func_177968_d(), BlockVine.field_176273_b, length);
            }
        }
    }

    private void addHangingVine(World world, BlockPos pos, PropertyBool prop, int length) {
        this.func_175903_a(world, pos, ModBlocks.endVine.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
        BlockPos blockpos = pos.func_177977_b();
        while (world.func_175623_d(blockpos) && length > 0) {
            this.func_175903_a(world, blockpos, ModBlocks.endVine.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
            blockpos = blockpos.func_177977_b();
            --length;
        }
    }

    private void buildTrunk(World world, Random rand, BlockPos center, int height) {
        int trunkCore = 5;
        int trunkDecoWidth = 7;
        for (int x = -trunkCore; x <= trunkCore; ++x) {
            for (int z = -trunkCore; z <= trunkCore; ++z) {
                int colHeight = Math.abs(x) <= 1 && Math.abs(z) <= 1 ? height : (Math.abs(x) <= Math.abs(z) ? 18 - Math.abs(x) - Math.abs(z) * 3 - rand.nextInt(2) : 18 - Math.abs(x) * 3 - Math.abs(z) - rand.nextInt(2));
                for (int y = 0; y < colHeight; ++y) {
                    this.placeLogAt(world, center.func_177982_a(x, y, z));
                }
            }
        }
    }

    private List<BranchInfo> buildBranches(World world, Random rand, BlockPos center, int trunkHeight) {
        ArrayList<BranchInfo> branchEndPos = new ArrayList<BranchInfo>();
        center = center.func_177982_a(0, trunkHeight - 2, 0);
        for (int n = 0; n < 7; ++n) {
            BlockPos[] branchArray;
            int branchAngle;
            int branchHeight;
            int branchLength;
            if (rand.nextInt(21) == 0 || n == 6 && rand.nextInt(8) != 0) continue;
            if (n < 4) {
                branchLength = 14 + rand.nextInt(8);
                branchHeight = 8 + rand.nextInt(7);
                branchAngle = MathUtils.randIntBetween(45 + 90 * n - 10, 45 + 90 * n + 10, rand);
            } else if (n < 6) {
                branchLength = 9 + rand.nextInt(7);
                branchHeight = 15 + rand.nextInt(3);
                branchAngle = MathUtils.randIntBetween(90 + 180 * (n - 4) - 35, 90 + 180 * (n - 4) + 35, rand);
            } else {
                branchLength = 5 + rand.nextInt(5);
                branchHeight = 5 + rand.nextInt(5);
                branchAngle = rand.nextInt(360);
            }
            double xAngleTranslation = Math.cos(Math.toRadians(branchAngle));
            double zAngleTranslation = Math.sin(Math.toRadians(branchAngle));
            int xOffset = (int)Math.round(1.0 * xAngleTranslation);
            int zOffset = (int)Math.round(1.0 * zAngleTranslation);
            BlockPos branchStart = center.func_177982_a(xOffset, 0, zOffset);
            BlockPos branchCurve = center.func_177982_a(branchLength / 3, branchHeight, 0);
            BlockPos branchEnd = center.func_177982_a(branchLength + xOffset, branchHeight, 0);
            int rotEndPosX = (int)Math.round((double)(branchLength + xOffset) * xAngleTranslation);
            int rotEndPosZ = (int)Math.round((double)(branchLength + zOffset) * zAngleTranslation);
            BlockPos rotatedBranchEnd = branchStart.func_177982_a(rotEndPosX, branchHeight, rotEndPosZ);
            branchEndPos.add(new BranchInfo(rotatedBranchEnd, branchAngle));
            for (BlockPos pos : branchArray = MathUtils.getQuadBezierArray(branchStart, branchCurve, branchEnd)) {
                int pxXoffset = pos.func_177958_n() - branchStart.func_177958_n();
                int pxYoffset = pos.func_177956_o() - branchStart.func_177956_o();
                int pxZoffset = pos.func_177952_p() - branchStart.func_177952_p();
                int pxDistance = pxXoffset;
                int angledX = (int)Math.round((double)pxDistance * xAngleTranslation);
                int angledZ = (int)Math.round((double)pxDistance * zAngleTranslation);
                this.placeLogAt(world, branchStart.func_177982_a(angledX, pxYoffset, angledZ));
                this.placeLogAt(world, branchStart.func_177982_a(angledX + xOffset, pxYoffset, angledZ));
                this.placeLogAt(world, branchStart.func_177982_a(angledX, pxYoffset, angledZ + zOffset));
                if (pxDistance > 5) continue;
                this.placeLogAt(world, branchStart.func_177982_a(angledX - xOffset, pxYoffset, angledZ - zOffset));
            }
        }
        return branchEndPos;
    }

    private void placeLogAt(World worldIn, BlockPos pos) {
        this.func_175903_a(worldIn, pos, LOG);
    }

    private void placeLeafAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos) || state == ModBlocks.endVine.func_176223_P()) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }

    protected void drawCurvedBresehnam(World world, BlockPos start, BlockPos end, BlockPos curvePos, IBlockState state) {
        for (BlockPos pixel : MathUtils.getQuadBezierArray(start, curvePos, end)) {
            this.func_175903_a(world, pixel, state);
        }
    }

    private class BranchInfo {
        BlockPos endPoint;
        int rotationAngle;

        public BranchInfo(BlockPos endPoint, int rotationAngle) {
            this.endPoint = endPoint;
            this.rotationAngle = rotationAngle;
        }
    }
}

