/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.block;

import fluke.stygian.block.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEndCactus
extends Block
implements IPlantable {
    public static final String REG_NAME = "endcactus";
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    protected static final AxisAlignedBB CACTUS_COLLISION_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.9375, 0.8125);
    protected static final AxisAlignedBB CACTUS_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);

    public BlockEndCactus() {
        super(Material.field_151570_A);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("stygian.endcactus");
        this.setRegistryName(REG_NAME);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_175623_d(blockpos)) {
            int cactusHeight = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(cactusHeight)).func_177230_c() == this) {
                ++cactusHeight;
            }
            if (cactusHeight < 7) {
                int age = (Integer)state.func_177229_b((IProperty)AGE);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (IBlockState)state, (boolean)true)) {
                    if (age == 15) {
                        worldIn.func_175656_a(blockpos, this.func_176223_P());
                        IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
                        worldIn.func_180501_a(pos, iblockstate, 4);
                        iblockstate.func_189546_a(worldIn, blockpos, (Block)this, pos);
                    } else {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return CACTUS_COLLISION_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return CACTUS_AABB.func_186670_a(pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() == ModBlocks.endCactus || state.func_177230_c() == ModBlocks.endMagma;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Nether;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMap mappy = new StateMap.Builder().func_178442_a(new IProperty[]{AGE}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mappy);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

