/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.world;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import xxrexraptorxx.minetraps.world.WorldGenerator;

public class WorldTickHandler {
    public static WorldTickHandler instance = new WorldTickHandler();
    public static TIntObjectHashMap<ArrayDeque<ChunkPos>> chunksToGen = new TIntObjectHashMap();

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            int dim = world.field_73011_w.getDimension();
            ArrayDeque chunks = (ArrayDeque)chunksToGen.get(dim);
            if (chunks != null && !chunks.isEmpty()) {
                ChunkPos c = (ChunkPos)chunks.pollFirst();
                long worldSeed = world.func_72905_C();
                Random rand = new Random(worldSeed);
                long xSeed = rand.nextLong() >> 3;
                long zSeed = rand.nextLong() >> 3;
                rand.setSeed(xSeed * (long)c.field_77276_a + zSeed * (long)c.field_77275_b ^ worldSeed);
                WorldGenerator.instance.generateWorld(rand, c.field_77276_a, c.field_77275_b, world, false);
                chunksToGen.put(dim, (Object)chunks);
            } else if (chunks != null) {
                chunksToGen.remove(dim);
            }
        }
    }
}

