/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.google.common.base.Predicate;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xxrexraptorxx.minetraps.main.ModBlocks;

public class BlockWallSpikes
extends BlockHorizontal {
    private final boolean isOn;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB OFF_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 1.0, 1.0);
    protected static final AxisAlignedBB OFF_WEST_AABB = new AxisAlignedBB(0.1, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB OFF_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1);
    protected static final AxisAlignedBB OFF_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.1, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB ON_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB ON_WEST_AABB = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB ON_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB ON_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);

    public BlockWallSpikes(boolean isOn) {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(1);
        this.isOn = isOn;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187677_b, SoundCategory.BLOCKS, 1.0f, 0.0f, false);
        this.setDefaultFacing(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.wallSpikes.func_176223_P(), 2);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.wallSpikesOn.func_176223_P(), 2);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187677_b, SoundCategory.BLOCKS, 1.0f, 0.0f, false);
        if (!worldIn.field_72995_K) {
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_175684_a(pos, (Block)this, 4);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.wallSpikesOn.func_176223_P(), 2);
                this.setDefaultFacing(worldIn, pos, state);
            }
        }
        if (!this.canBePlacedOn(worldIn, pos.func_177977_b())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.isOn && !worldIn.func_175640_z(pos)) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187677_b, SoundCategory.BLOCKS, 1.0f, 0.0f, false);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, ModBlocks.wallSpikes.func_176223_P(), 2);
                this.setDefaultFacing(worldIn, pos, state);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && this.isOn) {
            entityIn.func_70097_a(DamageSource.field_76377_j, 4.0f);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.wallSpikes);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ModBlocks.wallSpikes);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(ModBlocks.wallSpikes);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> addList, ITooltipFlag advanced) {
        addList.add(ChatFormatting.GRAY + "Needs redstone power");
        addList.add(ChatFormatting.RED + "WIP");
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.func_177977_b());
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185917_h() || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockFence;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isOn) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case NORTH: {
                    return ON_NORTH_AABB;
                }
                case SOUTH: {
                    return ON_SOUTH_AABB;
                }
                case WEST: {
                    return ON_WEST_AABB;
                }
            }
            return ON_EAST_AABB;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return OFF_NORTH_AABB;
            }
            case SOUTH: {
                return OFF_SOUTH_AABB;
            }
            case WEST: {
                return OFF_WEST_AABB;
            }
        }
        return OFF_EAST_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

