/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.village;

import fathertoast.specialai.config.Config;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.Village;

public class CommandVillageInfo
extends CommandBase {
    private static final String NAME = "villageinfo";
    private static final String LANG_KEY = "commands.specialai.villageinfo.";

    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.specialai.villageinfo.usage";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String standingKey;
        TextFormatting standingColor;
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
        player.field_70170_p.func_175714_ae();
        Village village = player.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)player), 0);
        if (village == null) {
            return;
        }
        BlockPos center = village.func_180608_a();
        int radius = village.func_75568_b();
        int houses = village.func_75567_c();
        int pop = village.func_75562_e();
        int maxPop = (int)((double)houses * 0.35);
        int golems = player.field_70170_p.func_72872_a(EntityIronGolem.class, new AxisAlignedBB((double)(center.func_177958_n() - radius), (double)(center.func_177956_o() - 4), (double)(center.func_177952_p() - radius), (double)(center.func_177958_n() + radius), (double)(center.func_177956_o() + 4), (double)(center.func_177952_p() + radius))).size();
        int maxGolems = houses > 20 ? pop / 10 : 0;
        int rep = village.getPlayerReputation(player.func_110124_au());
        if (rep <= -15) {
            standingColor = TextFormatting.RED;
            standingKey = "hated";
        } else if (rep <= Config.get().VILLAGES.BLOCK_ATTACK_LIMIT) {
            standingColor = TextFormatting.YELLOW;
            standingKey = "disliked";
        } else if (rep <= Config.get().VILLAGES.BLOCK_REP_LIMIT) {
            standingColor = TextFormatting.WHITE;
            standingKey = "neutral";
        } else {
            standingColor = TextFormatting.GREEN;
            standingKey = "trusted";
        }
        if (Config.get().VILLAGES.COMMAND_INCLUDE_CENTER) {
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.specialai.villageinfo.pos", (Object[])new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()});
        }
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.specialai.villageinfo.size", (Object[])new Object[]{houses, radius});
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.specialai.villageinfo.pop", (Object[])new Object[]{pop, maxPop, golems, maxGolems});
        String standing = standingColor.toString() + new TextComponentTranslation("commands.specialai.villageinfo.rep." + standingKey, new Object[0]).func_150260_c() + TextFormatting.RESET.toString();
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.specialai.villageinfo.rep", (Object[])new Object[]{rep, standing});
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.specialai.villageinfo.rep." + standingKey + ".note"), (Object[])new Object[]{"\n", "\n"});
    }
}

