/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.util;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockHelper {
    public static final int EVENT_ATTACK_DOOR_WOOD = 1019;
    public static final int EVENT_ATTACK_DOOR_IRON = 1020;
    public static final int EVENT_BREAK_DOOR_WOOD = 1021;
    public static final int EVENT_SPAWNER_PARTICLES = 2004;
    public static final int EVENT_BONEMEAL_PARTICLES = 2005;

    public static boolean shouldDamage(IBlockState state, EntityLiving entity, boolean needsTool, World world, BlockPos pos) {
        return state.func_185887_b(world, pos) >= 0.0f && !state.func_185904_a().func_76224_d() && (!needsTool || BlockHelper.canHarvestBlock(entity.func_184614_ca(), state)) && state.func_177230_c().canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)entity) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)entity, (BlockPos)pos, (IBlockState)state);
    }

    public static float getDamageAmount(IBlockState state, EntityLiving entity, World world, BlockPos pos) {
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!BlockHelper.canHarvestBlock(entity.func_184614_ca(), state)) {
            return 1.0f / (hardness * 100.0f);
        }
        return BlockHelper.getCurrentStrengthVsBlock(entity, state) / (hardness * 30.0f);
    }

    public static boolean canHarvestBlock(ItemStack stack, IBlockState state) {
        return !state.func_185904_a().func_76224_d() && (state.func_185904_a().func_76229_l() || !stack.func_190926_b() && stack.func_150998_b(state));
    }

    public static float getCurrentStrengthVsBlock(EntityLiving entity, IBlockState state) {
        int efficiency;
        float strength;
        ItemStack held = entity.func_184614_ca();
        float f = strength = held.func_190926_b() ? 1.0f : held.func_150997_a(state);
        if (strength > 1.0f && (efficiency = EnchantmentHelper.func_185293_e((EntityLivingBase)entity)) > 0) {
            strength += (float)(efficiency * efficiency + 1);
        }
        if (entity.func_70644_a(MobEffects.field_76422_e)) {
            strength *= 1.0f + (float)(entity.func_70660_b(MobEffects.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70644_a(MobEffects.field_76419_f)) {
            strength *= 1.0f - (float)(entity.func_70660_b(MobEffects.field_76419_f).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)entity)) {
            strength /= 5.0f;
        }
        if (!entity.field_70122_E) {
            strength /= 5.0f;
        }
        return strength < 0.0f ? 0.0f : strength;
    }
}

