/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.grief;

import fathertoast.specialai.SpecialAIMod;
import fathertoast.specialai.ai.AIHandler;
import fathertoast.specialai.config.Config;
import fathertoast.specialai.config.TargetBlock;
import fathertoast.specialai.util.BlockHelper;
import fathertoast.specialai.util.EntityFakePlayer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAIGriefBlocks
extends EntityAIBase {
    protected final EntityLiving theEntity;
    private final Random random;
    private int scanRangeXZ;
    private int scanRangeY;
    private final boolean griefingEnabled;
    private float griefBreakSpeed;
    private boolean griefNeedsTool;
    private boolean griefTargetsLights;
    private TargetBlock.TargetMap griefTargetBlocks;
    private TargetBlock.TargetMap griefTargetLootBlocks;
    private TargetBlock.TargetMap griefBlacklist;
    private final boolean fiddlingEnabled;
    private TargetBlock.TargetMap fiddleTargetBlocks;
    private TargetBlock.TargetMap fiddleBlacklist;
    private Activity currentActivity = Activity.NONE;
    private boolean canSee;
    private int sightCounter;
    private int giveUpDelay;
    private int fiddleDelay;
    private BlockPos targetPos;
    private IBlockState targetBlock;
    private int hitCounter;
    private float blockDamage;
    private int lastBlockDamage = -1;

    public EntityAIGriefBlocks(EntityLiving entity, boolean griefing, boolean fiddling, NBTTagCompound tag) {
        this.theEntity = entity;
        this.random = entity.func_70681_au();
        this.griefingEnabled = griefing;
        this.fiddlingEnabled = fiddling;
        this.func_75248_a(3);
        this.scanRangeXZ = tag.func_74764_b("IdleScanRangeXZ") ? (int)tag.func_74771_c("IdleScanRangeXZ") : Config.get().IDLE_AI.RANGE_XZ;
        this.scanRangeY = tag.func_74764_b("IdleScanRangeY") ? (int)tag.func_74771_c("IdleScanRangeY") : Config.get().IDLE_AI.RANGE_Y;
        if (this.griefingEnabled) {
            this.griefBreakSpeed = tag.func_74764_b("GriefBreakSpeed") ? tag.func_74760_g("GriefBreakSpeed") : Config.get().GRIEFING.BREAK_SPEED;
            this.griefNeedsTool = tag.func_74764_b("GriefNeedsTool") ? tag.func_74767_n("GriefNeedsTool") : Config.get().GRIEFING.REQUIRES_TOOLS;
            this.griefTargetsLights = tag.func_74764_b("GriefLights") ? tag.func_74767_n("GriefLights") : Config.get().GRIEFING.BREAK_LIGHTS;
            this.griefTargetBlocks = tag.func_74764_b("GriefBlocks") ? TargetBlock.newTargetDefinition(tag.func_74779_i("GriefBlocks")) : Config.get().GRIEFING.TARGET_LIST;
            this.griefTargetLootBlocks = tag.func_74764_b("GriefLootable") ? TargetBlock.newTargetDefinition(tag.func_74779_i("GriefLootable")) : Config.get().GRIEFING.TARGET_LOOTABLE;
            this.griefBlacklist = tag.func_74764_b("GriefBlacklist") ? TargetBlock.newTargetDefinition(tag.func_74779_i("GriefBlacklist")) : Config.get().GRIEFING.BLACK_LIST;
        }
        if (this.fiddlingEnabled) {
            this.fiddleTargetBlocks = tag.func_74764_b("FiddleBlocks") ? TargetBlock.newTargetDefinition(tag.func_74779_i("FiddleBlocks")) : Config.get().FIDDLING.TARGET_LIST;
            this.fiddleBlacklist = tag.func_74764_b("FiddleBlacklist") ? TargetBlock.newTargetDefinition(tag.func_74779_i("FiddleBlacklist")) : Config.get().FIDDLING.BLACK_LIST;
        }
    }

    public boolean func_75250_a() {
        if (!this.theEntity.func_184218_aH() && ForgeEventFactory.getMobGriefingEvent((World)this.theEntity.field_70170_p, (Entity)this.theEntity)) {
            --this.fiddleDelay;
            --this.sightCounter;
            if (this.sightCounter <= 0) {
                this.sightCounter = Config.get().IDLE_AI.SCAN_DELAY;
                int x = (int)Math.floor(this.theEntity.field_70165_t);
                int y = (int)Math.floor(this.theEntity.field_70163_u);
                int z = (int)Math.floor(this.theEntity.field_70161_v);
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                for (int i = 0; i < Config.get().IDLE_AI.SCAN_COUNT && AIHandler.canScan(); ++i) {
                    pos.func_181079_c(x + this.random.nextInt(this.scanRangeXZ) - this.random.nextInt(this.scanRangeXZ), y + this.random.nextInt(this.scanRangeY) - this.random.nextInt(this.scanRangeY), z + this.random.nextInt(this.scanRangeXZ) - this.random.nextInt(this.scanRangeXZ));
                    if (!this.tryTargetBlock((BlockPos)pos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        switch (this.currentActivity) {
            case GRIEFING: {
                return this.continueExecutingGriefing();
            }
            case FIDDLING: {
                return this.continueExecutingFiddling();
            }
        }
        return false;
    }

    private boolean continueExecutingGriefing() {
        return !this.theEntity.func_184218_aH() && (this.blockDamage > 0.0f || this.giveUpDelay < 400) && this.theEntity.field_70170_p.func_180495_p(this.targetPos).func_177230_c() == this.targetBlock.func_177230_c();
    }

    private boolean continueExecutingFiddling() {
        return !this.theEntity.func_184218_aH() && this.giveUpDelay < 400 && this.theEntity.field_70170_p.func_180495_p(this.targetPos).func_177230_c() == this.targetBlock.func_177230_c();
    }

    public boolean func_75252_g() {
        return this.currentActivity == Activity.GRIEFING && !this.madCreeper() || this.blockDamage == 0.0f;
    }

    public void func_75249_e() {
        this.sightCounter = 0;
        this.canSee = false;
        this.hitCounter = 0;
        this.blockDamage = 0.0f;
        this.lastBlockDamage = -1;
        this.theEntity.func_70661_as().func_75484_a(this.theEntity.func_70661_as().func_179680_a(this.targetPos), 1.0);
    }

    public void func_75251_c() {
        this.blockDamage = 0.0f;
        this.giveUpDelay = 0;
        this.targetBlock = null;
        if (!this.theEntity.func_70661_as().func_75500_f()) {
            this.theEntity.func_70661_as().func_75499_g();
        }
        switch (this.currentActivity) {
            case GRIEFING: {
                this.resetTaskGriefing();
                break;
            }
            case FIDDLING: {
                this.resetTaskFiddling();
                break;
            }
        }
        this.currentActivity = Activity.NONE;
    }

    private void resetTaskGriefing() {
        if (this.madCreeper()) {
            ((EntityCreeper)this.theEntity).func_70829_a(-1);
        } else {
            this.theEntity.field_70170_p.func_175715_c(this.theEntity.func_145782_y(), this.targetPos, -1);
        }
    }

    private void resetTaskFiddling() {
        this.fiddleDelay = 80 + this.theEntity.func_70681_au().nextInt(81);
    }

    public void func_75246_d() {
        switch (this.currentActivity) {
            case GRIEFING: {
                this.updateTaskGriefing();
                break;
            }
            case FIDDLING: {
                this.updateTaskFiddling();
                break;
            }
        }
    }

    private void updateTaskGriefing() {
        this.theEntity.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 30.0f, 30.0f);
        if (this.canSee) {
            if (!this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75499_g();
            }
            if (this.madCreeper()) {
                ((EntityCreeper)this.theEntity).func_70829_a(1);
                this.blockDamage = 1.0f;
            } else {
                int damage;
                if (this.hitCounter == 0) {
                    this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                    SoundType sound = this.targetBlock.func_177230_c().getSoundType(this.targetBlock, this.theEntity.field_70170_p, this.targetPos, (Entity)this.theEntity);
                    this.theEntity.field_70170_p.func_184133_a(null, this.targetPos, sound.func_185845_c(), this.theEntity.func_184176_by(), sound.func_185843_a(), sound.func_185847_b() * 0.8f);
                }
                if (++this.hitCounter >= 5) {
                    this.hitCounter = 0;
                }
                this.blockDamage += BlockHelper.getDamageAmount(this.targetBlock, this.theEntity, this.theEntity.field_70170_p, this.targetPos) * this.griefBreakSpeed;
                if (this.blockDamage >= 1.0f) {
                    if (this.targetBlock == Blocks.field_150458_ak) {
                        this.theEntity.field_70170_p.func_180501_a(this.targetPos, Blocks.field_150346_d.func_176223_P(), 3);
                    } else {
                        this.theEntity.field_70170_p.func_175655_b(this.targetPos, Config.get().GRIEFING.LEAVE_DROPS);
                        if (Config.get().GRIEFING.BREAK_SOUND) {
                            this.theEntity.field_70170_p.func_175718_b(1021, this.targetPos, 0);
                        }
                        this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
                    }
                    this.blockDamage = 0.0f;
                    this.resetTaskGriefing();
                    this.currentActivity = Activity.NONE;
                }
                if ((damage = (int)Math.ceil(this.blockDamage * 10.0f) - 1) != this.lastBlockDamage) {
                    this.theEntity.field_70170_p.func_175715_c(this.theEntity.func_145782_y(), this.targetPos, damage);
                    this.lastBlockDamage = damage;
                }
            }
        } else {
            if (this.sightCounter-- <= 0) {
                this.sightCounter = 10 + this.random.nextInt(5);
                if (this.checkSight()) {
                    this.sightCounter += 3;
                }
            }
            if (++this.giveUpDelay > 400) {
                this.theEntity.func_70661_as().func_75499_g();
                this.resetTaskGriefing();
                this.currentActivity = Activity.NONE;
            } else if (this.theEntity.func_70661_as().func_75500_f() && this.giveUpDelay % 12 == 0) {
                this.theEntity.func_70661_as().func_75484_a(this.theEntity.func_70661_as().func_179680_a(this.targetPos), 1.0);
            }
        }
    }

    private void updateTaskFiddling() {
        this.theEntity.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 30.0f, 30.0f);
        if (this.canSee) {
            try {
                if (this.theEntity.field_70170_p instanceof WorldServer) {
                    if (this.targetBlock.func_177230_c() instanceof BlockTNT) {
                        ((BlockTNT)this.targetBlock.func_177230_c()).func_180692_a(this.theEntity.field_70170_p, this.targetPos, this.targetBlock.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)this.theEntity);
                        this.theEntity.field_70170_p.func_180501_a(this.targetPos, Blocks.field_150350_a.func_176223_P(), 11);
                    } else {
                        EntityFakePlayer fakePlayer = new EntityFakePlayer(this.theEntity);
                        this.targetBlock.func_177230_c().func_180639_a(this.theEntity.field_70170_p, this.targetPos, this.targetBlock, (EntityPlayer)fakePlayer, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.5f, 0.5f, 0.5f);
                        fakePlayer.updateWrappedEntityState();
                    }
                }
            }
            catch (Exception ex) {
                SpecialAIMod.log().warn("Failed to fiddle with block '{}'", Block.field_149771_c.func_177774_c((Object)this.targetBlock.func_177230_c()), (Object)ex);
            }
            this.theEntity.func_184609_a(EnumHand.MAIN_HAND);
            this.theEntity.func_70661_as().func_75499_g();
            this.resetTaskFiddling();
            this.currentActivity = Activity.NONE;
        } else {
            if (this.sightCounter-- <= 0) {
                this.sightCounter = 10 + this.random.nextInt(5);
                if (this.checkSight()) {
                    this.sightCounter += 3;
                }
            }
            if (++this.giveUpDelay > 400) {
                this.theEntity.func_70661_as().func_75499_g();
                this.resetTaskFiddling();
                this.currentActivity = Activity.NONE;
            } else if (this.theEntity.func_70661_as().func_75500_f() && this.giveUpDelay % 13 == 0) {
                this.theEntity.func_70661_as().func_75484_a(this.theEntity.func_70661_as().func_179680_a(this.targetPos), 1.0);
            }
        }
    }

    private boolean checkSight() {
        double x = (double)this.targetPos.func_177958_n() + 0.5;
        double y = (double)this.targetPos.func_177956_o() + 0.5;
        double z = (double)this.targetPos.func_177952_p() + 0.5;
        if (this.theEntity.func_70092_e(x, y - (double)this.theEntity.func_70047_e(), z) <= (double)(Config.get().IDLE_AI.REACH * Config.get().IDLE_AI.REACH)) {
            Vec3d posVec = new Vec3d(this.theEntity.field_70165_t, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v);
            if (this.checkSight(posVec, x, y + (this.theEntity.field_70163_u > y ? 0.5 : -0.5), z) || this.checkSight(posVec, x + (this.theEntity.field_70165_t > x ? 0.5 : -0.5), y, z) || this.checkSight(posVec, x, y, z + (this.theEntity.field_70161_v > z ? 0.5 : -0.5))) {
                this.canSee = true;
            }
            return true;
        }
        return false;
    }

    private boolean checkSight(Vec3d posVec, double x, double y, double z) {
        Vec3d targetVec = new Vec3d(x, y, z);
        RayTraceResult target = this.theEntity.field_70170_p.func_72933_a(posVec, targetVec);
        return target == null || RayTraceResult.Type.BLOCK.equals((Object)target.field_72313_a) && this.targetPos.equals((Object)target.func_178782_a()) || this.tryTargetObstructingBlock(target.func_178782_a());
    }

    private boolean tryTargetObstructingBlock(BlockPos pos) {
        IBlockState block = this.theEntity.field_70170_p.func_180495_p(pos);
        switch (this.currentActivity) {
            case GRIEFING: {
                return this.tryTargetBlockGriefing(block, pos);
            }
            case FIDDLING: {
                return this.tryTargetBlockFiddling(block, pos);
            }
        }
        return false;
    }

    private boolean tryTargetBlock(BlockPos pos) {
        IBlockState block = this.theEntity.field_70170_p.func_180495_p(pos);
        return this.griefingEnabled && this.tryTargetBlockGriefing(block, pos) || this.fiddlingEnabled && this.fiddleDelay <= 0 && this.tryTargetBlockFiddling(block, pos);
    }

    private boolean tryTargetBlockGriefing(IBlockState block, BlockPos pos) {
        if (this.isValidTargetForGriefing(block, pos)) {
            this.currentActivity = Activity.GRIEFING;
            this.targetPos = pos.func_185334_h();
            this.targetBlock = block;
            return true;
        }
        return false;
    }

    private boolean tryTargetBlockFiddling(IBlockState block, BlockPos pos) {
        if (this.isValidTargetForFiddling(block, pos)) {
            this.currentActivity = Activity.FIDDLING;
            this.targetPos = pos.func_185334_h();
            this.targetBlock = block;
            return true;
        }
        return false;
    }

    private boolean isValidTargetForGriefing(IBlockState block, BlockPos pos) {
        if (block.func_177230_c() != Blocks.field_150350_a && !this.griefBlacklist.matches(block) && (this.griefTargetsLights && block.getLightValue((IBlockAccess)this.theEntity.field_70170_p, pos) > 1 && !(block.func_177230_c() instanceof BlockFire) && block.func_177230_c() != Blocks.field_150439_ay && !(block.func_177230_c() instanceof BlockOre) && block.func_177230_c() != Blocks.field_189877_df || this.griefTargetBlocks.matches(block) || this.griefTargetLootBlocks.matches(block) && this.isLootContainerTargetable(block, pos))) {
            return BlockHelper.shouldDamage(block, this.theEntity, this.griefNeedsTool && !this.madCreeper(), this.theEntity.field_70170_p, pos);
        }
        return false;
    }

    private boolean isValidTargetForFiddling(IBlockState block, BlockPos pos) {
        return block != null && block != Blocks.field_150350_a && !this.fiddleBlacklist.matches(block) && this.fiddleTargetBlocks.matches(block);
    }

    private boolean isLootContainerTargetable(IBlockState block, BlockPos pos) {
        TileEntity container = this.theEntity.field_70170_p.func_175625_s(pos);
        return container instanceof ILootContainer && ((ILootContainer)container).func_184276_b() == null;
    }

    private boolean madCreeper() {
        return Config.get().GRIEFING.MAD_CREEPERS && this.theEntity instanceof EntityCreeper;
    }

    private static enum Activity {
        NONE,
        GRIEFING,
        FIDDLING;

    }
}

