/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.nbt;

import com.ldtteam.jvoxelizer.util.nbt.INBTBase;
import com.ldtteam.jvoxelizer.util.nbt.INBTByteArray;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import com.ldtteam.jvoxelizer.util.nbt.INBTList;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class NBTStreamSupport {
    private NBTStreamSupport() {
        throw new IllegalStateException("Tried to initialize: NBTStreamSupport but this is a Utility class.");
    }

    public static Stream<INBTBase> streamList(INBTList list) {
        return list.stream();
    }

    public static Stream<Byte> streamByteArray(INBTByteArray byteArray) {
        return IntStream.range(0, byteArray.getValue().length).mapToObj(i -> byteArray.getValue()[i]);
    }

    public static Stream<Map.Entry<String, INBTBase>> streamCompound(INBTCompound compound) {
        return compound.keySet().stream().map(key -> new AbstractMap.SimpleImmutableEntry<String, Object>((String)key, compound.get(key)));
    }
}

