/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.math;

import com.ldtteam.blockout.util.math.Axis;
import org.jetbrains.annotations.NotNull;

public final class Vector2d {
    public static final Vector2d DEFAULT = new Vector2d();
    private final double x;
    private final double y;

    public Vector2d() {
        this(0.0, 0.0);
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d(double d) {
        this(d, d);
    }

    public Vector2d(@NotNull Vector2d other) {
        this(other.getX(), other.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @NotNull
    public static Vector2d fromString(@NotNull String string) {
        String[] components = string.split(",");
        if (components.length == 1) {
            return new Vector2d(Double.parseDouble(components[0]));
        }
        if (components.length == 2) {
            return new Vector2d(Double.parseDouble(components[0]), Double.parseDouble(components[1]));
        }
        return new Vector2d();
    }

    @NotNull
    public static Vector2d maximize(@NotNull Vector2d first, @NotNull Vector2d second) {
        return first.maximize(second);
    }

    @NotNull
    public Vector2d maximize(@NotNull Vector2d other) {
        return new Vector2d(Math.max(this.getX(), other.getX()), Math.max(this.getY(), other.getY()));
    }

    @NotNull
    public static Vector2d minimize(@NotNull Vector2d first, @NotNull Vector2d second) {
        return first.minimize(second);
    }

    @NotNull
    public Vector2d minimize(@NotNull Vector2d other) {
        return new Vector2d(Math.min(this.getX(), other.getX()), Math.min(this.getY(), other.getY()));
    }

    @NotNull
    public Vector2d move(double delta) {
        return this.move(delta, delta);
    }

    @NotNull
    public Vector2d move(double deltaX, double deltaY) {
        return new Vector2d(this.getX() + deltaX, this.getY() + deltaY);
    }

    @NotNull
    public Vector2d move(Vector2d delta) {
        return this.move(delta.getX(), delta.getY());
    }

    @NotNull
    public double cross(Vector2d B) {
        return this.getX() * B.getY() - this.getY() * B.getX();
    }

    @NotNull
    public Vector2d normalize() {
        double t = this.length();
        return new Vector2d(this.getX() / t, this.getY() / t);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @NotNull
    public Vector2d nullifyNegatives() {
        return this.invert().nullifyPositives().invert();
    }

    @NotNull
    public Vector2d invert() {
        return this.mul(-1.0);
    }

    @NotNull
    public Vector2d nullifyPositives() {
        return new Vector2d(this.getX() > 0.0 ? 0.0 : this.getX(), this.getY() > 0.0 ? 0.0 : this.getY());
    }

    @NotNull
    public Vector2d mul(double val) {
        return new Vector2d(this.getX() * val, this.getY() * val);
    }

    @NotNull
    public Vector2d div(Vector2d fac) {
        return new Vector2d(this.getX() / fac.getX(), this.getY() / fac.getY());
    }

    @NotNull
    public Vector2d clamp(@NotNull Vector2d min, @NotNull Vector2d max) {
        return new Vector2d(this.getAxisValueIfInBetween(Axis.X, this, min, max), this.getAxisValueIfInBetween(Axis.Y, this, min, max));
    }

    private double getAxisValueIfInBetween(Axis axis, @NotNull Vector2d target, @NotNull Vector2d min, @NotNull Vector2d max) {
        return Math.min(max.get(axis), Math.max(min.get(axis), target.get(axis)));
    }

    public double get(Axis a) {
        switch (a) {
            case X: {
                return this.getX();
            }
            case Y: {
                return this.getY();
            }
        }
        throw new IllegalArgumentException("Unknown Axis");
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.getX());
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getY());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2d)) {
            return false;
        }
        Vector2d vector2d = (Vector2d)o;
        if (Double.compare(vector2d.getX(), this.getX()) != 0) {
            return false;
        }
        return Double.compare(vector2d.getY(), this.getY()) == 0;
    }

    public String toString() {
        return String.format("%s,%s", this.x, this.y);
    }
}

