/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.math;

import com.ldtteam.blockout.util.math.Vector2d;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class BoundingBox {
    @NotNull
    private final Vector2d localOrigin;
    @NotNull
    private final Vector2d size;

    public BoundingBox() {
        this(new Vector2d(), new Vector2d());
    }

    public BoundingBox(Vector2d localOrigin, Vector2d size) {
        this.localOrigin = localOrigin;
        this.size = size;
    }

    public BoundingBox(@NotNull BoundingBox other) {
        this(new Vector2d(other.getLocalOrigin()), new Vector2d(other.getSize()));
    }

    @NotNull
    public Vector2d getLocalOrigin() {
        return this.localOrigin;
    }

    @NotNull
    public Vector2d getSize() {
        return this.size;
    }

    public static BoundingBox fromString(@NotNull String string) {
        String[] parts = string.split(",");
        Double[] components = Arrays.stream(parts).map(s -> Double.parseDouble(s.trim())).collect(Collectors.toList()).toArray(new Double[4]);
        if (components.length != 4) {
            throw new IllegalArgumentException("StringConverter does not contain 4 parts");
        }
        return new BoundingBox(new Vector2d(components[0], components[1]), new Vector2d(components[2], components[3]));
    }

    @NotNull
    public Vector2d getLowerRightCoordinate() {
        return this.getLocalOrigin().move(this.getSize().getX(), 0.0);
    }

    @NotNull
    public Vector2d getUpperLeftCoordinate() {
        return this.getLocalOrigin().move(0.0, this.getSize().getY());
    }

    public boolean includes(@NotNull Vector2d point) {
        return this.getLowerLeftCoordinate().getX() <= point.getX() && this.getLowerLeftCoordinate().getY() <= point.getY() && this.getUpperRightCoordinate().getX() >= point.getX() && this.getUpperRightCoordinate().getY() >= point.getY();
    }

    public boolean intersects(@NotNull BoundingBox box) {
        return this.includes(box.getLowerLeftCoordinate()) || this.includes(box.getLowerRightCoordinate()) || this.includes(box.getUpperLeftCoordinate()) || this.includes(box.getUpperRightCoordinate()) || box.includes(this.getLowerLeftCoordinate()) || box.includes(this.getLowerRightCoordinate()) || box.includes(this.getUpperLeftCoordinate()) || box.includes(this.getUpperRightCoordinate());
    }

    public boolean includesEntirely(@NotNull BoundingBox box) {
        return this.equals(this.include(box));
    }

    @NotNull
    public BoundingBox include(@NotNull BoundingBox box) {
        return box.include(this.getLowerLeftCoordinate()).include(this.getLowerRightCoordinate()).include(this.getUpperRightCoordinate()).include(this.getUpperLeftCoordinate());
    }

    @NotNull
    public BoundingBox include(@NotNull Vector2d point) {
        if (this.includes(point)) {
            return new BoundingBox(this);
        }
        Vector2d deltaLocalOrigin = this.getLocalOrigin().move(point.invert()).invert().nullifyPositives();
        Vector2d newLocalOrigin = this.getLocalOrigin().move(deltaLocalOrigin);
        Vector2d deltaUpperRight = this.getUpperRightCoordinate().move(point.invert()).nullifyPositives().invert();
        Vector2d newUpperRight = this.getUpperRightCoordinate().move(deltaUpperRight);
        Vector2d newSize = newUpperRight.move(newLocalOrigin.invert());
        return new BoundingBox(newLocalOrigin, newSize);
    }

    @NotNull
    public BoundingBox intersect(@NotNull BoundingBox box) {
        return BoundingBox.fromExtremities(box.getLowerLeftCoordinate().clamp(this.getLowerLeftCoordinate(), this.getUpperRightCoordinate()), box.getUpperRightCoordinate().clamp(this.getLowerLeftCoordinate(), this.getUpperRightCoordinate()));
    }

    @NotNull
    public static BoundingBox fromExtremities(@NotNull Vector2d lowerLeft, @NotNull Vector2d upperRight) {
        return new BoundingBox(lowerLeft, upperRight.move(lowerLeft.invert()));
    }

    @NotNull
    public Vector2d getLowerLeftCoordinate() {
        return this.getLocalOrigin();
    }

    @NotNull
    public Vector2d getUpperRightCoordinate() {
        return this.getLocalOrigin().move(this.getSize().getX(), this.getSize().getY());
    }

    @NotNull
    public BoundingBox scale(@NotNull Vector2d scalingFactor) {
        return new BoundingBox(this.getLocalOrigin().div(scalingFactor), this.getSize().div(scalingFactor));
    }

    public int hashCode() {
        int result = this.getLocalOrigin().hashCode();
        result = 31 * result + this.getSize().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundingBox)) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (!this.getLocalOrigin().equals(that.getLocalOrigin())) {
            return false;
        }
        return this.getSize().equals(that.getSize());
    }

    public String toString() {
        return this.getLocalOrigin().getX() + "," + this.getLocalOrigin().getY() + "," + this.getSize().getX() + "," + this.getSize().getY() + ",";
    }
}

