/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.util.color;

import com.google.common.collect.Maps;
import com.ldtteam.blockout.util.color.IColor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ColorUtils {
    private static final Map<String, Integer> nameToColorMap = Maps.newHashMap();
    public static int MARKER = 59392;

    private ColorUtils() {
        throw new IllegalStateException("Tried to initialize: ColorUtils but this is a Utility class.");
    }

    @NotNull
    public static String convertToFontRendererColor(@NotNull String input) {
        if (input.startsWith(String.valueOf((char)MARKER))) {
            return input;
        }
        return ColorUtils.convertToColor(input).encodeColor();
    }

    @NotNull
    public static IColor convertToColor(@NotNull String input) {
        if (input.isEmpty()) {
            return IColor.create(nameToColorMap.get("white"));
        }
        if (nameToColorMap.containsKey(input.toLowerCase())) {
            return IColor.create(nameToColorMap.get(input.toLowerCase()));
        }
        try {
            return IColor.create(Integer.parseInt(input));
        }
        catch (Exception e) {
            return IColor.create(nameToColorMap.get("white"));
        }
    }

    static {
        nameToColorMap.put("AliceBlue".toLowerCase(), -984833);
        nameToColorMap.put("AntiqueWhite".toLowerCase(), -332841);
        nameToColorMap.put("Aqua".toLowerCase(), -16711681);
        nameToColorMap.put("Aquamarine".toLowerCase(), -8388652);
        nameToColorMap.put("Azure".toLowerCase(), -983041);
        nameToColorMap.put("Beige".toLowerCase(), -657956);
        nameToColorMap.put("Bisque".toLowerCase(), -6972);
        nameToColorMap.put("Black".toLowerCase(), -16777216);
        nameToColorMap.put("BlanchedAlmond".toLowerCase(), -5171);
        nameToColorMap.put("Blue".toLowerCase(), -16776961);
        nameToColorMap.put("BlueViolet".toLowerCase(), -7722014);
        nameToColorMap.put("Brown".toLowerCase(), -5952982);
        nameToColorMap.put("BurlyWood".toLowerCase(), -2180985);
        nameToColorMap.put("CadetBlue".toLowerCase(), -10510688);
        nameToColorMap.put("Chartreuse".toLowerCase(), -8388864);
        nameToColorMap.put("Chocolate".toLowerCase(), -2987746);
        nameToColorMap.put("Coral".toLowerCase(), -32944);
        nameToColorMap.put("CornflowerBlue".toLowerCase(), -10185235);
        nameToColorMap.put("Cornsilk".toLowerCase(), -1828);
        nameToColorMap.put("Crimson".toLowerCase(), -2354116);
        nameToColorMap.put("Cyan".toLowerCase(), -16711681);
        nameToColorMap.put("DarkBlue".toLowerCase(), -16777077);
        nameToColorMap.put("DarkCyan".toLowerCase(), -16741493);
        nameToColorMap.put("DarkGoldenRod".toLowerCase(), -4684277);
        nameToColorMap.put("DarkGray".toLowerCase(), -5658199);
        nameToColorMap.put("DarkGreen".toLowerCase(), -16751616);
        nameToColorMap.put("DarkKhaki".toLowerCase(), -4343957);
        nameToColorMap.put("DarkMagenta".toLowerCase(), -7667573);
        nameToColorMap.put("DarkOliveGreen".toLowerCase(), -11179217);
        nameToColorMap.put("DarkOrange".toLowerCase(), -29696);
        nameToColorMap.put("DarkOrchid".toLowerCase(), -6737204);
        nameToColorMap.put("DarkRed".toLowerCase(), -7667712);
        nameToColorMap.put("DarkSalmon".toLowerCase(), -1468806);
        nameToColorMap.put("DarkSeaGreen".toLowerCase(), -7357297);
        nameToColorMap.put("DarkSlateBlue".toLowerCase(), -12042869);
        nameToColorMap.put("DarkSlateGray".toLowerCase(), -13676721);
        nameToColorMap.put("DarkTurquoise".toLowerCase(), -16724271);
        nameToColorMap.put("DarkViolet".toLowerCase(), -7077677);
        nameToColorMap.put("DeepPink".toLowerCase(), -60269);
        nameToColorMap.put("DeepSkyBlue".toLowerCase(), -16728065);
        nameToColorMap.put("DimGray".toLowerCase(), -9868951);
        nameToColorMap.put("DodgerBlue".toLowerCase(), -14774017);
        nameToColorMap.put("FireBrick".toLowerCase(), -5103070);
        nameToColorMap.put("FloralWhite".toLowerCase(), -1296);
        nameToColorMap.put("ForestGreen".toLowerCase(), -14513374);
        nameToColorMap.put("Fuchsia".toLowerCase(), -65281);
        nameToColorMap.put("Gainsboro".toLowerCase(), -2302756);
        nameToColorMap.put("GhostWhite".toLowerCase(), -460545);
        nameToColorMap.put("Gold".toLowerCase(), -10496);
        nameToColorMap.put("GoldenRod".toLowerCase(), -2448096);
        nameToColorMap.put("Gray".toLowerCase(), -8355712);
        nameToColorMap.put("Green".toLowerCase(), -16744448);
        nameToColorMap.put("GreenYellow".toLowerCase(), -5374161);
        nameToColorMap.put("HoneyDew".toLowerCase(), -983056);
        nameToColorMap.put("HotPink".toLowerCase(), -38476);
        nameToColorMap.put("IndianRed".toLowerCase(), -3318692);
        nameToColorMap.put("Indigo".toLowerCase(), -11861886);
        nameToColorMap.put("Ivory".toLowerCase(), -16);
        nameToColorMap.put("Khaki".toLowerCase(), -989556);
        nameToColorMap.put("Lavender".toLowerCase(), -1644806);
        nameToColorMap.put("LavenderBlush".toLowerCase(), -3851);
        nameToColorMap.put("LawnGreen".toLowerCase(), -8586240);
        nameToColorMap.put("LemonChiffon".toLowerCase(), -1331);
        nameToColorMap.put("LightBlue".toLowerCase(), -5383962);
        nameToColorMap.put("LightCoral".toLowerCase(), -1015680);
        nameToColorMap.put("LightCyan".toLowerCase(), -2031617);
        nameToColorMap.put("LightGoldenRodYellow".toLowerCase(), -329006);
        nameToColorMap.put("LightGray".toLowerCase(), -2894893);
        nameToColorMap.put("LightGreen".toLowerCase(), -7278960);
        nameToColorMap.put("LightPink".toLowerCase(), -18751);
        nameToColorMap.put("LightSalmon".toLowerCase(), -24454);
        nameToColorMap.put("LightSeaGreen".toLowerCase(), -14634326);
        nameToColorMap.put("LightSkyBlue".toLowerCase(), -7876870);
        nameToColorMap.put("LightSlateGray".toLowerCase(), -8943463);
        nameToColorMap.put("LightSteelBlue".toLowerCase(), -5192482);
        nameToColorMap.put("LightYellow".toLowerCase(), -32);
        nameToColorMap.put("Lime".toLowerCase(), -16711936);
        nameToColorMap.put("LimeGreen".toLowerCase(), -13447886);
        nameToColorMap.put("Linen".toLowerCase(), -331546);
        nameToColorMap.put("Magenta".toLowerCase(), -65281);
        nameToColorMap.put("Maroon".toLowerCase(), -8388608);
        nameToColorMap.put("MediumAquaMarine".toLowerCase(), -10039894);
        nameToColorMap.put("MediumBlue".toLowerCase(), -16777011);
        nameToColorMap.put("MediumOrchid".toLowerCase(), -4565549);
        nameToColorMap.put("MediumPurple".toLowerCase(), -7114533);
        nameToColorMap.put("MediumSeaGreen".toLowerCase(), -12799119);
        nameToColorMap.put("MediumSlateBlue".toLowerCase(), -8689426);
        nameToColorMap.put("MediumSpringGreen".toLowerCase(), -16713062);
        nameToColorMap.put("MediumTurquoise".toLowerCase(), -12004916);
        nameToColorMap.put("MediumVioletRed".toLowerCase(), -3730043);
        nameToColorMap.put("MidnightBlue".toLowerCase(), -15132304);
        nameToColorMap.put("MintCream".toLowerCase(), -655366);
        nameToColorMap.put("MistyRose".toLowerCase(), -6943);
        nameToColorMap.put("Moccasin".toLowerCase(), -6987);
        nameToColorMap.put("NavajoWhite".toLowerCase(), -8531);
        nameToColorMap.put("Navy".toLowerCase(), -16777088);
        nameToColorMap.put("OldLace".toLowerCase(), -133658);
        nameToColorMap.put("Olive".toLowerCase(), -8355840);
        nameToColorMap.put("OliveDrab".toLowerCase(), -9728477);
        nameToColorMap.put("Orange".toLowerCase(), -23296);
        nameToColorMap.put("OrangeRed".toLowerCase(), -47872);
        nameToColorMap.put("Orchid".toLowerCase(), -2461482);
        nameToColorMap.put("PaleGoldenRod".toLowerCase(), -1120086);
        nameToColorMap.put("PaleGreen".toLowerCase(), -6751336);
        nameToColorMap.put("PaleTurquoise".toLowerCase(), -5247250);
        nameToColorMap.put("PaleVioletRed".toLowerCase(), -2396013);
        nameToColorMap.put("PapayaWhip".toLowerCase(), -4139);
        nameToColorMap.put("PeachPuff".toLowerCase(), -9543);
        nameToColorMap.put("Peru".toLowerCase(), -3308225);
        nameToColorMap.put("Pink".toLowerCase(), -16181);
        nameToColorMap.put("Plum".toLowerCase(), -2252579);
        nameToColorMap.put("PowderBlue".toLowerCase(), -5185306);
        nameToColorMap.put("Purple".toLowerCase(), -8388480);
        nameToColorMap.put("Red".toLowerCase(), -65536);
        nameToColorMap.put("RosyBrown".toLowerCase(), -4419697);
        nameToColorMap.put("RoyalBlue".toLowerCase(), -12490271);
        nameToColorMap.put("SaddleBrown".toLowerCase(), -7650029);
        nameToColorMap.put("Salmon".toLowerCase(), -360334);
        nameToColorMap.put("SandyBrown".toLowerCase(), -744352);
        nameToColorMap.put("SeaGreen".toLowerCase(), -13726889);
        nameToColorMap.put("SeaShell".toLowerCase(), -2578);
        nameToColorMap.put("Sienna".toLowerCase(), -6270419);
        nameToColorMap.put("Silver".toLowerCase(), -4144960);
        nameToColorMap.put("SkyBlue".toLowerCase(), -7876885);
        nameToColorMap.put("SlateBlue".toLowerCase(), -9807155);
        nameToColorMap.put("SlateGray".toLowerCase(), -9404272);
        nameToColorMap.put("Snow".toLowerCase(), -1286);
        nameToColorMap.put("SpringGreen".toLowerCase(), -16711809);
        nameToColorMap.put("SteelBlue".toLowerCase(), -12156236);
        nameToColorMap.put("Tan".toLowerCase(), -2968436);
        nameToColorMap.put("Teal".toLowerCase(), -16744320);
        nameToColorMap.put("Thistle".toLowerCase(), -2572328);
        nameToColorMap.put("Tomato".toLowerCase(), -40121);
        nameToColorMap.put("Turquoise".toLowerCase(), -12525360);
        nameToColorMap.put("Violet".toLowerCase(), -1146130);
        nameToColorMap.put("Wheat".toLowerCase(), -663885);
        nameToColorMap.put("White".toLowerCase(), -1);
        nameToColorMap.put("WhiteSmoke".toLowerCase(), -657931);
        nameToColorMap.put("Yellow".toLowerCase(), -256);
        nameToColorMap.put("YellowGreen".toLowerCase(), -6632142);
    }
}

