/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.definitions.deserializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.ldtteam.blockout.style.definitions.StylesDefinition;
import com.ldtteam.blockout.util.json.IdentifierDeserializer;
import com.ldtteam.blockout.util.stream.StreamHelper;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;

public class StylesDefinitionDeserializer
implements JsonDeserializer<StylesDefinition> {
    public static final Type CONST_STYLES_DEFINITION_TYPE = new TypeToken<StylesDefinition>(){}.getType();
    private static final Gson CONST_GSON = new GsonBuilder().registerTypeAdapter(IdentifierDeserializer.CONST_IDENTIFIER_TYPE, (Object)IdentifierDeserializer.getInstance()).create();
    private static StylesDefinitionDeserializer ourInstance = new StylesDefinitionDeserializer();

    private StylesDefinitionDeserializer() {
    }

    public static StylesDefinitionDeserializer getInstance() {
        return ourInstance;
    }

    public StylesDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            throw new IllegalArgumentException("Styles definition needs to be array that points to styles.");
        }
        JsonArray array = json.getAsJsonArray();
        Collection styles = StreamHelper.getJsonArrayAsStream(array).map(e -> (IIdentifier)CONST_GSON.fromJson(e, IdentifierDeserializer.CONST_IDENTIFIER_TYPE)).collect(Collectors.toList());
        return new StylesDefinition(styles);
    }
}

