/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.definitions.deserializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.ldtteam.blockout.style.definitions.StyleDefinition;
import com.ldtteam.blockout.util.json.IdentifierDeserializer;
import com.ldtteam.blockout.util.stream.StreamHelper;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;

public class StyleDefinitionDeserializer
implements JsonDeserializer<StyleDefinition> {
    public static final Type CONST_STYLE_DEFINTION_TYPE = new TypeToken<StyleDefinition>(){}.getType();
    private static final Gson CONST_GSON = new GsonBuilder().registerTypeAdapter(IdentifierDeserializer.CONST_IDENTIFIER_TYPE, (Object)IdentifierDeserializer.getInstance()).create();
    private static StyleDefinitionDeserializer ourInstance = new StyleDefinitionDeserializer();

    private StyleDefinitionDeserializer() {
    }

    public static StyleDefinitionDeserializer getInstance() {
        return ourInstance;
    }

    public StyleDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Style Definition needs an id and a collection of resource type definition locations");
        }
        JsonObject object = json.getAsJsonObject();
        if (!object.has("id")) {
            throw new JsonParseException("Style Definition needs an id.");
        }
        IIdentifier id = (IIdentifier)CONST_GSON.fromJson(object.get("id"), IdentifierDeserializer.CONST_IDENTIFIER_TYPE);
        if (!object.has("types") || !object.get("types").isJsonArray()) {
            throw new JsonParseException("Style Definition needs a types array.");
        }
        Collection resourceTypeLocations = StreamHelper.getJsonArrayAsStream(object.get("types").getAsJsonArray()).map(e -> (IIdentifier)CONST_GSON.fromJson(e, IdentifierDeserializer.CONST_IDENTIFIER_TYPE)).collect(Collectors.toList());
        return new StyleDefinition(id, resourceTypeLocations);
    }
}

