/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.definitions.deserializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.ldtteam.blockout.style.definitions.ResourceDefinition;
import com.ldtteam.blockout.style.definitions.ResourceTypeDefinition;
import com.ldtteam.blockout.style.definitions.deserializers.ResourceDefinitionDeserializer;
import com.ldtteam.blockout.util.stream.StreamHelper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;

public class ResourceTypeDefinitionDeserializer
implements JsonDeserializer<ResourceTypeDefinition> {
    public static final Type CONST_RESOURCE_TYPE_DEFINITION_TYPE = new TypeToken<ResourceTypeDefinition>(){}.getType();
    private static final Gson CONST_GSON = new GsonBuilder().registerTypeAdapter(ResourceDefinitionDeserializer.CONST_RESOURCE_DEFINITION_TYPE, (Object)ResourceDefinitionDeserializer.getInstance()).create();
    private static ResourceTypeDefinitionDeserializer ourInstance = new ResourceTypeDefinitionDeserializer();

    private ResourceTypeDefinitionDeserializer() {
    }

    public static ResourceTypeDefinitionDeserializer getInstance() {
        return ourInstance;
    }

    public ResourceTypeDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("ResourceType Definition needs to be object with type id and array with resource data.");
        }
        JsonObject object = json.getAsJsonObject();
        if (!object.has("id") || !object.get("id").isJsonPrimitive()) {
            throw new JsonParseException("ResourceType Definition does not have an id string");
        }
        String typeId = object.get("id").getAsString();
        if (!object.has("resources") || !object.get("resources").isJsonArray()) {
            throw new JsonParseException("ResourceType Definition does not have a resource array.");
        }
        JsonArray resources = object.get("resources").getAsJsonArray();
        Collection resourceDefinitions = StreamHelper.getJsonArrayAsStream(resources).map(e -> (ResourceDefinition)CONST_GSON.fromJson(e, ResourceDefinitionDeserializer.CONST_RESOURCE_DEFINITION_TYPE)).collect(Collectors.toList());
        return new ResourceTypeDefinition(typeId, resourceDefinitions);
    }
}

