/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.definitions.deserializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.ldtteam.blockout.style.definitions.ResourceDefinition;
import com.ldtteam.blockout.util.json.IdentifierDeserializer;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.lang.reflect.Type;

public class ResourceDefinitionDeserializer
implements JsonDeserializer<ResourceDefinition> {
    public static final Type CONST_RESOURCE_DEFINITION_TYPE = new TypeToken<ResourceDefinition>(){}.getType();
    private static final Gson CONST_GSON = new GsonBuilder().registerTypeAdapter(IdentifierDeserializer.CONST_IDENTIFIER_TYPE, (Object)IdentifierDeserializer.getInstance()).create();
    private static ResourceDefinitionDeserializer ourInstance = new ResourceDefinitionDeserializer();

    private ResourceDefinitionDeserializer() {
    }

    public static ResourceDefinitionDeserializer getInstance() {
        return ourInstance;
    }

    public ResourceDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Resource definition data needs to be object with id and data.");
        }
        JsonObject object = json.getAsJsonObject();
        if (!object.has("id")) {
            throw new JsonParseException("Resource definition data has no id.");
        }
        IIdentifier id = (IIdentifier)CONST_GSON.fromJson(object.get("id"), IdentifierDeserializer.CONST_IDENTIFIER_TYPE);
        JsonObject data = object.has("data") ? object.get("data") : new JsonObject();
        return new ResourceDefinition(id, (JsonElement)data);
    }
}

