/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.style.core;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockout.style.core.IStyle;
import com.ldtteam.blockout.style.core.resources.core.IResource;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public interface IStyleManager {
    @NotNull
    default public <T extends IResource> T getResource(@NotNull IIdentifier styleId, @NotNull IIdentifier resourceId) throws IllegalArgumentException {
        Optional resource;
        IStyle primaryStyle = (IStyle)this.getStyles().get((Object)styleId);
        if (primaryStyle != null && (resource = primaryStyle.getResource(resourceId)).isPresent()) {
            return (T)((IResource)resource.get());
        }
        return (T)this.getStyles().entrySet().stream().filter(e -> !((IIdentifier)e.getKey()).equals(styleId)).map(e -> ((IStyle)e.getValue()).getResource(resourceId)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No style has a resource with the given id: %s", resourceId)));
    }

    @NotNull
    public ImmutableMap<IIdentifier, IStyle> getStyles();

    public void loadStyles();
}

