/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.proxy;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.ldtteam.blockout.connector.core.IGuiController;
import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.connector.core.ILoaderManager;
import com.ldtteam.blockout.connector.core.IUIElementFactoryController;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.network.INetworkManager;
import com.ldtteam.blockout.management.render.IRenderManager;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.reflection.IReflectionManager;
import com.ldtteam.blockout.style.core.IStyleManager;
import com.ldtteam.blockout.style.core.resources.loader.IResourceLoaderManager;
import com.ldtteam.blockout.template.ITemplateEngine;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.client.renderer.font.IFontRenderer;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public interface IProxy {
    public static IProxy getInstance() {
        return ProxyHolder.getInstance();
    }

    public void onPreInit();

    @NotNull
    public IGuiController getGuiController();

    @NotNull
    public ILoaderManager getLoaderManager();

    @NotNull
    public IUIElementFactoryController getFactoryController();

    @NotNull
    public InputStream getResourceStream(@NotNull IIdentifier var1) throws Exception;

    @NotNull
    public Vector2d getImageSize(@NotNull IIdentifier var1);

    @NotNull
    public INetworkManager generateNewNetworkManagerForGui(@NotNull IGuiKey var1);

    @NotNull
    public IUpdateManager generateNewUpdateManager(@NotNull IUIManager var1);

    @NotNull
    public IDimension getDimensionFromDimensionId(@NotNull int var1);

    @NotNull
    public IRenderManager generateNewRenderManager();

    @NotNull
    public IFontRenderer getFontRenderer();

    @NotNull
    public IResourceLoaderManager getResourceLoaderManager();

    @NotNull
    public IStyleManager getStyleManager();

    @NotNull
    public ITemplateEngine getTemplateEngine();

    @NotNull
    public IGuiController getClientSideOnlyGuiController();

    @NotNull
    public IBindingEngine getBindingEngine();

    @NotNull
    public Injector getInjector();

    @NotNull
    public String convertToColorCode(@NotNull String var1);

    @NotNull
    public IReflectionManager getReflectionManager();

    public void registerFactoryInjectionModule(@NotNull Module var1);
}

