/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.factory;

import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.component.ComponentType;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.NBTBaseConverter;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import com.ldtteam.jvoxelizer.block.state.IBlockState;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.item.IItemStack;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTDependingConverters {
    private static final NBTBaseConverter<INBTCompound> COMPOUND_NBT_BASE_CONVERTER = new NBTBaseConverter.CompoundConverter();

    public static final class EntityConverter
    implements IUIElementDataComponentConverter<IEntity> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return COMPOUND_NBT_BASE_CONVERTER.matchesInputTypes(component);
        }

        @Override
        @NotNull
        public IEntity readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            INBTCompound compound = (INBTCompound)COMPOUND_NBT_BASE_CONVERTER.readFromElement(component, sourceData, params);
            IEntity entity = IEntity.create();
            entity.read(compound);
            return entity;
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull IEntity value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            INBTCompound compound = value.write();
            return COMPOUND_NBT_BASE_CONVERTER.writeToElement(compound, newComponentInstanceProducer);
        }
    }

    public static final class BlockStateConverter
    implements IUIElementDataComponentConverter<IBlockState> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return COMPOUND_NBT_BASE_CONVERTER.matchesInputTypes(component);
        }

        @Override
        @NotNull
        public IBlockState readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            INBTCompound compound = (INBTCompound)COMPOUND_NBT_BASE_CONVERTER.readFromElement(component, sourceData, params);
            IBlockState state = IBlockState.create();
            state.read(compound);
            return state;
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull IBlockState value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            INBTCompound compound = value.write();
            return COMPOUND_NBT_BASE_CONVERTER.writeToElement(compound, newComponentInstanceProducer);
        }
    }

    public static final class ItemStackConverter
    implements IUIElementDataComponentConverter<IItemStack> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return COMPOUND_NBT_BASE_CONVERTER.matchesInputTypes(component);
        }

        @Override
        @NotNull
        public IItemStack readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            INBTCompound compound = (INBTCompound)COMPOUND_NBT_BASE_CONVERTER.readFromElement(component, sourceData, params);
            IItemStack stack = IItemStack.create();
            stack.read(compound);
            return stack;
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull IItemStack value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            INBTCompound compound = value.write();
            return COMPOUND_NBT_BASE_CONVERTER.writeToElement(compound, newComponentInstanceProducer);
        }
    }
}

