/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.factory;

import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.component.ComponentType;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import com.ldtteam.blockout.util.NBTType;
import com.ldtteam.blockout.util.elementdata.IUIElementDataComponentStreamSupport;
import com.ldtteam.blockout.util.nbt.NBTStreamSupport;
import com.ldtteam.jvoxelizer.util.nbt.INBTBase;
import com.ldtteam.jvoxelizer.util.nbt.INBTByte;
import com.ldtteam.jvoxelizer.util.nbt.INBTByteArray;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import com.ldtteam.jvoxelizer.util.nbt.INBTDouble;
import com.ldtteam.jvoxelizer.util.nbt.INBTFloat;
import com.ldtteam.jvoxelizer.util.nbt.INBTInteger;
import com.ldtteam.jvoxelizer.util.nbt.INBTList;
import com.ldtteam.jvoxelizer.util.nbt.INBTLong;
import com.ldtteam.jvoxelizer.util.nbt.INBTShort;
import com.ldtteam.jvoxelizer.util.nbt.INBTString;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NBTBaseConverter<T extends INBTBase>
implements IUIElementDataComponentConverter<T> {
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private static final Map<Pattern, NBTType> TYPE_MATCHING_PATTERNS = new LinkedHashMap<Pattern, NBTType>();
    private static final Map<NBTType, Function<IUIElementDataComponent, INBTBase>> TYPE_CONVERSION_FUNCTIONS = new EnumMap<NBTType, Function<IUIElementDataComponent, INBTBase>>(NBTType.class);
    private static final Map<NBTType, BiFunction<INBTBase, Function<ComponentType, ? extends IUIElementDataComponent>, IUIElementDataComponent>> NBT_CONVERSION_FUNCTIONS = new EnumMap<NBTType, BiFunction<INBTBase, Function<ComponentType, ? extends IUIElementDataComponent>, IUIElementDataComponent>>(NBTType.class);
    private final NBTType type;

    protected NBTBaseConverter(NBTType type) {
        this.type = type;
    }

    private static NBTType getNBTType(@NotNull IUIElementDataComponent component) throws IllegalArgumentException {
        long childrenTypeCount;
        if (component.isList() && (childrenTypeCount = IUIElementDataComponentStreamSupport.streamList(component).map(NBTBaseConverter::getNBTType).distinct().count()) == 1L) {
            NBTType type = IUIElementDataComponentStreamSupport.streamList(component).map(NBTBaseConverter::getNBTType).distinct().findFirst().get();
            if (type == NBTType.TAG_BYTE) {
                return NBTType.TAG_BYTE_ARRAY;
            }
            return NBTType.TAG_LIST;
        }
        if (component.isComplex()) {
            return NBTType.TAG_COMPOUND;
        }
        return TYPE_MATCHING_PATTERNS.entrySet().stream().filter(tmpe -> ((Pattern)tmpe.getKey()).matcher(component.getAsString()).matches()).map(Map.Entry::getValue).findFirst().orElse(NBTType.TAG_STRING);
    }

    private static <T extends INBTBase> INBTBase convertToValue(@NotNull IUIElementDataComponent component, @NotNull Function<String, T> converter) {
        return (INBTBase)converter.apply(component.getAsString());
    }

    private static INBTBase convertToByteArray(@NotNull IUIElementDataComponent component) {
        List<Byte> bytes = IUIElementDataComponentStreamSupport.streamList(component).map(TYPE_CONVERSION_FUNCTIONS.get((Object)NBTType.TAG_BYTE)::apply).map(nbtBase -> (INBTByte)nbtBase).map(INBTByte::getValue).collect(Collectors.toList());
        byte[] byteArray = ArrayUtils.toPrimitive((Byte[])bytes.toArray(new Byte[0]));
        INBTByteArray list = INBTBase.create((byte[])byteArray);
        return list;
    }

    private static INBTBase convertToList(@NotNull IUIElementDataComponent component) {
        INBTList list = INBTBase.create((Iterable)IUIElementDataComponentStreamSupport.streamList(component).map(child -> TYPE_CONVERSION_FUNCTIONS.get((Object)NBTBaseConverter.getNBTType(child)).apply((IUIElementDataComponent)child)).collect(Collectors.toList()));
        return list;
    }

    private static final INBTBase convertToNBTTagCompound(@NotNull IUIElementDataComponent component) {
        INBTCompound compound = INBTBase.create();
        IUIElementDataComponentStreamSupport.streamMap(component).forEach(child -> {
            INBTBase nbtBase = TYPE_CONVERSION_FUNCTIONS.get((Object)NBTBaseConverter.getNBTType((IUIElementDataComponent)child.getValue())).apply((IUIElementDataComponent)child.getValue());
            String name = (String)child.getKey();
            if (compound.containsKey((Object)name)) {
                throw new IllegalArgumentException(String.format("Given jsonElement contains multiple entries with the same key: %s", name));
            }
            compound.put((Object)name, (Object)nbtBase);
        });
        return compound;
    }

    private static <C extends IUIElementDataComponent> C convertFromValue(@NotNull INBTBase base, Function<ComponentType, C> newInstanceCreator) {
        IUIElementDataComponent newInstance = (IUIElementDataComponent)newInstanceCreator.apply(ComponentType.STRING);
        newInstance.setString(base.toString());
        return (C)newInstance;
    }

    private static <C extends IUIElementDataComponent> C convertFromByteArray(INBTBase base, Function<ComponentType, C> newInstanceCreator) {
        INBTByteArray byteArray = (INBTByteArray)base;
        IUIElementDataComponent newInstance = (IUIElementDataComponent)newInstanceCreator.apply(ComponentType.LIST);
        newInstance.setList(NBTStreamSupport.streamByteArray(byteArray).map(INBTBase::create).map(tag -> NBT_CONVERSION_FUNCTIONS.get((Object)NBTType.TAG_BYTE).apply((INBTBase)tag, newInstanceCreator)).collect(Collectors.toList()));
        return (C)newInstance;
    }

    private static <C extends IUIElementDataComponent> C convertFromList(INBTBase base, Function<ComponentType, C> newInstanceCreator) {
        INBTList listTag = (INBTList)base;
        IUIElementDataComponent newInstance = (IUIElementDataComponent)newInstanceCreator.apply(ComponentType.LIST);
        newInstance.setList(NBTStreamSupport.streamList(listTag).map(b -> NBT_CONVERSION_FUNCTIONS.get((Object)NBTType.fromNBTBase(b)).apply((INBTBase)b, newInstanceCreator)).collect(Collectors.toList()));
        return (C)newInstance;
    }

    private static <C extends IUIElementDataComponent> C convertFromCompound(INBTBase base, Function<ComponentType, C> newInstanceCreator) {
        INBTCompound compoundTag = (INBTCompound)base;
        IUIElementDataComponent newInstance = (IUIElementDataComponent)newInstanceCreator.apply(ComponentType.COMPLEX);
        newInstance.setMap(NBTStreamSupport.streamCompound(compoundTag).map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), NBT_CONVERSION_FUNCTIONS.get((Object)NBTType.fromNBTBase((INBTBase)entry.getValue())).apply((INBTBase)entry.getValue(), newInstanceCreator))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return (C)newInstance;
    }

    @Override
    public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
        return NBTBaseConverter.getNBTType(component) == this.type;
    }

    @Override
    @NotNull
    public T readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
        return (T)TYPE_CONVERSION_FUNCTIONS.get((Object)NBTBaseConverter.getNBTType(component)).apply(component);
    }

    @Override
    public <C extends IUIElementDataComponent> C writeToElement(@NotNull T value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
        return (C)NBT_CONVERSION_FUNCTIONS.get((Object)NBTType.fromNBTBase(value)).apply((INBTBase)value, (Function<ComponentType, ? extends IUIElementDataComponent>)newComponentInstanceProducer);
    }

    static {
        TYPE_MATCHING_PATTERNS.put(DOUBLE_PATTERN_NOSUFFIX, NBTType.TAG_DOUBLE);
        TYPE_MATCHING_PATTERNS.put(DOUBLE_PATTERN, NBTType.TAG_DOUBLE);
        TYPE_MATCHING_PATTERNS.put(FLOAT_PATTERN, NBTType.TAG_FLOAT);
        TYPE_MATCHING_PATTERNS.put(BYTE_PATTERN, NBTType.TAG_BYTE);
        TYPE_MATCHING_PATTERNS.put(LONG_PATTERN, NBTType.TAG_LONG);
        TYPE_MATCHING_PATTERNS.put(SHORT_PATTERN, NBTType.TAG_SHORT);
        TYPE_MATCHING_PATTERNS.put(INT_PATTERN, NBTType.TAG_INT);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE, component -> NBTBaseConverter.convertToValue(component, byteString -> INBTBase.create((byte)Byte.parseByte(byteString.replace("b", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE_ARRAY, NBTBaseConverter::convertToByteArray);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_COMPOUND, NBTBaseConverter::convertToNBTTagCompound);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_DOUBLE, component -> NBTBaseConverter.convertToValue(component, doubleString -> INBTBase.create((double)Double.parseDouble(doubleString.replace("d", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_FLOAT, component -> NBTBaseConverter.convertToValue(component, floatString -> INBTBase.create((float)Float.parseFloat(floatString.replace("f", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_SHORT, component -> NBTBaseConverter.convertToValue(component, shortString -> INBTBase.create((short)Short.parseShort(shortString.replace("s", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_LONG, component -> NBTBaseConverter.convertToValue(component, longString -> INBTBase.create((long)Long.parseLong(longString.replace("l", "")))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_INT, component -> NBTBaseConverter.convertToValue(component, intString -> INBTBase.create((int)Integer.parseInt(intString))));
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_LIST, NBTBaseConverter::convertToList);
        TYPE_CONVERSION_FUNCTIONS.put(NBTType.TAG_STRING, component -> NBTBaseConverter.convertToValue(component, INBTBase::create));
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_BYTE_ARRAY, NBTBaseConverter::convertFromByteArray);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_COMPOUND, NBTBaseConverter::convertFromCompound);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_DOUBLE, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_FLOAT, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_INT, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_LONG, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_SHORT, NBTBaseConverter::convertFromValue);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_LIST, NBTBaseConverter::convertFromList);
        NBT_CONVERSION_FUNCTIONS.put(NBTType.TAG_STRING, NBTBaseConverter::convertFromValue);
    }

    public static final class CompoundConverter
    extends NBTBaseConverter<INBTCompound> {
        public CompoundConverter() {
            super(NBTType.TAG_COMPOUND);
        }
    }

    public static final class ListConverter
    extends NBTBaseConverter<INBTList> {
        public ListConverter() {
            super(NBTType.TAG_LIST);
        }
    }

    public static final class StringConverter
    extends NBTBaseConverter<INBTString> {
        public StringConverter() {
            super(NBTType.TAG_STRING);
        }
    }

    public static final class ByteArrayConverter
    extends NBTBaseConverter<INBTByteArray> {
        public ByteArrayConverter() {
            super(NBTType.TAG_BYTE_ARRAY);
        }
    }

    public static final class DoubleConverter
    extends NBTBaseConverter<INBTDouble> {
        public DoubleConverter() {
            super(NBTType.TAG_DOUBLE);
        }
    }

    public static final class FloatConverter
    extends NBTBaseConverter<INBTFloat> {
        public FloatConverter() {
            super(NBTType.TAG_FLOAT);
        }
    }

    public static final class LongConverter
    extends NBTBaseConverter<INBTLong> {
        public LongConverter() {
            super(NBTType.TAG_LONG);
        }
    }

    public static final class IntConverter
    extends NBTBaseConverter<INBTInteger> {
        public IntConverter() {
            super(NBTType.TAG_INT);
        }
    }

    public static final class ShortConverter
    extends NBTBaseConverter<INBTShort> {
        public ShortConverter() {
            super(NBTType.TAG_SHORT);
        }
    }

    public static final class ByteConverter
    extends NBTBaseConverter<INBTByte> {
        public ByteConverter() {
            super(NBTType.TAG_BYTE);
        }
    }
}

