/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.factory;

import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.component.ComponentType;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementDataComponentConverters {
    private ElementDataComponentConverters() {
        throw new IllegalStateException("Tried to initialize: ElementDataComponentConverters but this is a Utility class.");
    }

    public static final class ListElementDataConverter
    implements IUIElementDataComponentConverter<List<IUIElementData<?>>> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isList();
        }

        @Override
        @NotNull
        public List<IUIElementData<?>> readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return component.getAsList().stream().map(iuiElementDataComponent -> iuiElementDataComponent.toIUIElementData((IUIElementHost)params[0])).collect(Collectors.toList());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull List<IUIElementData<?>> value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent listCompound = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.LIST);
            listCompound.setList(value.stream().map(iuiElementData -> {
                IUIElementDataComponent compound = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.COMPLEX);
                return iuiElementData.toDataComponent(compound);
            }).collect(Collectors.toList()));
            return (C)listCompound;
        }
    }

    public static final class ElementDataConverter
    implements IUIElementDataComponentConverter<IUIElementData<?>> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isComplex();
        }

        @Override
        @NotNull
        public IUIElementData readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return component.toIUIElementData((IUIElementHost)params[0]);
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull IUIElementData<?> value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent compound = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.COMPLEX);
            return (C)value.toDataComponent(compound);
        }
    }
}

