/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.factory;

import com.google.common.collect.Lists;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.AxisDistanceBuilder;
import com.ldtteam.blockout.element.values.Orientation;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.component.ComponentType;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseValueComponentConverters {
    private BaseValueComponentConverters() {
    }

    public static final class DummyListContextConverter
    implements IUIElementDataComponentConverter<ArrayList> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isList();
        }

        @Override
        @NotNull
        public ArrayList readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return Lists.newArrayList();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull ArrayList value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            return (C)((IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.LIST));
        }
    }

    public static final class BoundingBoxConverter
    implements IUIElementDataComponentConverter<BoundingBox> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public BoundingBox readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return BoundingBox.fromString(component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull BoundingBox value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.toString());
            return (C)newInstance;
        }
    }

    public static final class Vector2dConverter
    implements IUIElementDataComponentConverter<Vector2d> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public Vector2d readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return Vector2d.fromString(component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Vector2d value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.toString());
            return (C)newInstance;
        }
    }

    public static final class OrientationConverter
    implements IUIElementDataComponentConverter<Orientation> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public Orientation readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return Orientation.fromString(component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Orientation value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.toString());
            return (C)newInstance;
        }
    }

    public static final class AlignmentConverter
    implements IUIElementDataComponentConverter<EnumSet<Alignment>> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isNumber() || component.isString();
        }

        @Override
        @NotNull
        public EnumSet<Alignment> readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return component.isNumber() ? Alignment.fromInt(component.getAsInteger()) : Alignment.fromString(component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull EnumSet<Alignment> value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.NUMBER);
            newInstance.setInteger(Alignment.toInt(value));
            return (C)newInstance;
        }
    }

    public static final class AxisDistanceConverter
    implements IUIElementDataComponentConverter<AxisDistance> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public AxisDistance readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            AxisDistanceBuilder builder = new AxisDistanceBuilder();
            builder.readFromString(sourceData.getMetaData().getParent().map(IUIElement::getElementSize).orElse(new Vector2d()), component.getAsString());
            return builder.build();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull AxisDistance value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.toString());
            return (C)newInstance;
        }
    }

    public static final class EnumSetValueConverter<E extends Enum<E>>
    implements IUIElementDataComponentConverter<EnumSet<E>> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public EnumSet<E> readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            Class clz = (Class)params[0];
            String contents = component.getAsString();
            return Arrays.stream(contents.split(",")).map(s -> Enum.valueOf(clz, s)).collect(Collectors.toCollection(() -> EnumSet.noneOf(clz)));
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull EnumSet<E> value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.stream().map(Enum::name).reduce((s1, s2) -> s1 + "," + s2).orElse(""));
            return (C)newInstance;
        }
    }

    public static final class EnumValueConverter<E extends Enum<E>>
    implements IUIElementDataComponentConverter<E> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public E readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            Class clz = (Class)params[0];
            return (E)Enum.valueOf(clz, component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull E value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(((Enum)value).name());
            return (C)newInstance;
        }
    }

    public static final class IdentifierConverter
    implements IUIElementDataComponentConverter<IIdentifier> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public IIdentifier readFromElement(@NotNull IUIElementDataComponent component, @Nullable IUIElementData sourceData, Object ... params) {
            return IIdentifier.create((String)component.getAsString());
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull IIdentifier value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value.toString());
            return (C)newInstance;
        }
    }

    public static final class IntegerConverter
    implements IUIElementDataComponentConverter<Integer> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isNumber();
        }

        @Override
        @NotNull
        public Integer readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            if (!component.isNumber()) {
                throw new IllegalArgumentException("Required a component of type integer.");
            }
            return component.getAsInteger();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Integer value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.NUMBER);
            newInstance.setInteger(value);
            return (C)newInstance;
        }
    }

    public static final class FloatConverter
    implements IUIElementDataComponentConverter<Float> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isNumber();
        }

        @Override
        @NotNull
        public Float readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            if (!component.isNumber()) {
                throw new IllegalArgumentException("Required a component of type float.");
            }
            return component.getAsFloat();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Float value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.NUMBER);
            newInstance.setFloat(value);
            return (C)newInstance;
        }
    }

    public static final class DoubleConverter
    implements IUIElementDataComponentConverter<Double> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isNumber();
        }

        @Override
        @NotNull
        public Double readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            if (!component.isNumber()) {
                throw new IllegalArgumentException("Required a component of type double.");
            }
            return component.getAsDouble();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Double value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.NUMBER);
            newInstance.setDouble(value);
            return (C)newInstance;
        }
    }

    public static final class BooleanConverter
    implements IUIElementDataComponentConverter<Boolean> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isBool();
        }

        @Override
        @NotNull
        public Boolean readFromElement(@NotNull IUIElementDataComponent component, @NotNull IUIElementData sourceData, Object ... params) {
            if (!component.isBool()) {
                throw new IllegalArgumentException("Required a component of type boolean.");
            }
            return component.getAsBoolean();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull Boolean value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.BOOL);
            newInstance.setBoolean(value);
            return (C)newInstance;
        }
    }

    public static final class StringConverter
    implements IUIElementDataComponentConverter<String> {
        @Override
        public boolean matchesInputTypes(@NotNull IUIElementDataComponent component) {
            return component.isString();
        }

        @Override
        @NotNull
        public String readFromElement(@NotNull IUIElementDataComponent component, IUIElementData sourceData, Object ... params) {
            if (!component.isString()) {
                throw new IllegalArgumentException("Required a component of type string.");
            }
            return component.getAsString();
        }

        @Override
        public <C extends IUIElementDataComponent> C writeToElement(@NotNull String value, @NotNull Function<ComponentType, C> newComponentInstanceProducer) {
            IUIElementDataComponent newInstance = (IUIElementDataComponent)newComponentInstanceProducer.apply(ComponentType.STRING);
            newInstance.setString(value);
            return (C)newInstance;
        }
    }
}

