/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.core;

import com.google.inject.Key;
import com.google.inject.internal.MoreTypes;
import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.property.Property;
import com.ldtteam.blockout.binding.property.PropertyCreationHelper;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementMetaData;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.loader.factory.core.IUIElementDataComponentConverter;
import com.ldtteam.blockout.proxy.ProxyHolder;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IUIElementData<C extends IUIElementDataComponent> {
    @NotNull
    public IUIElementMetaData getMetaData();

    default public <T> IDependencyObject<T> getFromRawDataWithProperty(@NotNull String name, @NotNull IBindingEngine engine, @NotNull Property<T> defaultProperty, @NotNull T defaultValue, @NotNull Type targetType, Object ... params) {
        return this.getComponentWithName(name).map(targetComponent -> engine.attemptBind((IUIElementDataComponent)targetComponent, defaultValue).orElseGet(() -> {
            MoreTypes.ParameterizedTypeImpl type = new MoreTypes.ParameterizedTypeImpl(null, IUIElementDataComponentConverter.class, new Type[]{targetType});
            IUIElementDataComponentConverter componentConverter = (IUIElementDataComponentConverter)ProxyHolder.getInstance().getInjector().getInstance(Key.get((Type)type));
            if (!componentConverter.matchesInputTypes((IUIElementDataComponent)targetComponent)) {
                return DependencyObjectHelper.createFromProperty(defaultProperty, defaultValue);
            }
            return DependencyObjectHelper.createFromValue(componentConverter.readFromElement((IUIElementDataComponent)targetComponent, this, params));
        })).orElse(DependencyObjectHelper.createFromProperty(defaultProperty, defaultValue));
    }

    @Nullable
    default public Optional<C> getComponentWithName(@NotNull String name) {
        return this.getComponentWithName(name, false);
    }

    @Nullable
    public Optional<C> getComponentWithName(@NotNull String var1, boolean var2);

    default public <T> IDependencyObject<T> getFromRawDataWithDefault(@NotNull String name, @NotNull IBindingEngine engine, @NotNull T defaultValue, @NotNull Type targetType, Object ... params) {
        return this.getFromRawDataWithProperty(name, engine, PropertyCreationHelper.createFromStaticValue(defaultValue), defaultValue, targetType, params);
    }

    default public <T> T getRawWithoutBinding(@NotNull String name, @Nullable T defaultValue, @NotNull Type targetType, Object ... params) {
        return (T)this.getComponentWithName(name).map(targetComponent -> {
            MoreTypes.ParameterizedTypeImpl type = new MoreTypes.ParameterizedTypeImpl(null, IUIElementDataComponentConverter.class, new Type[]{targetType});
            IUIElementDataComponentConverter componentConverter = (IUIElementDataComponentConverter)ProxyHolder.getInstance().getInjector().getInstance(Key.get((Type)type));
            if (!componentConverter.matchesInputTypes((IUIElementDataComponent)targetComponent)) {
                return defaultValue;
            }
            return componentConverter.readFromElement((IUIElementDataComponent)targetComponent, this, params);
        }).orElse(defaultValue);
    }

    public <D extends IUIElementDataComponent> D toDataComponent(@NotNull D var1);
}

