/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.loader.binding.engine;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.loader.binding.core.IBindingCommand;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.binding.core.IBindingTransformer;
import com.ldtteam.blockout.loader.core.component.IUIElementDataComponent;
import com.ldtteam.blockout.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBindingEngine
implements IBindingEngine {
    private static final String COMMAND_SYNTAX_KEYWORD = "%COMMAND_SYNTAX%";
    private static final String COMMAND_DATA_KEYWORD = "%COMMAND_DATA%";
    private static final String TRANSFORMER_NAME = "transformers";
    private static final String BINDINGCOMMAND_PATTERN = "\\{(%COMMAND_SYNTAX%):(%COMMAND_DATA%)((:)(?<transformers>.+))*}";
    private static SimpleBindingEngine ourInstance = new SimpleBindingEngine();
    private final Map<Pattern, IBindingCommand> commandMap = new LinkedHashMap<Pattern, IBindingCommand>();
    private final Map<String, IBindingTransformer> transformerMap = new HashMap<String, IBindingTransformer>();

    private SimpleBindingEngine() {
    }

    public static SimpleBindingEngine getInstance() {
        return ourInstance;
    }

    @Override
    public <T> Optional<IDependencyObject<T>> attemptBind(@NotNull IUIElementDataComponent component, @Nullable T defaultValue) {
        try {
            for (Map.Entry<Pattern, IBindingCommand> knownPatternsAndCommands : this.commandMap.entrySet()) {
                Matcher attemptMatcher = knownPatternsAndCommands.getKey().matcher(component.getAsString());
                if (!attemptMatcher.matches()) continue;
                return Optional.of(this.executeBindingAttempt(attemptMatcher, knownPatternsAndCommands.getValue(), defaultValue));
            }
        }
        catch (ClassCastException cce) {
            Log.getLogger().warn("Failed to convert binding types into another. Either your transformer order or binding is broken.", (Throwable)cce);
            return Optional.of(DependencyObjectHelper.createFromValue(defaultValue));
        }
        catch (Exception ex) {
            Log.getLogger().error("Failed to build binding.", (Throwable)ex);
            return Optional.of(DependencyObjectHelper.createFromValue(defaultValue));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public IBindingEngine registerBindingCommand(IBindingCommand ... commands) {
        for (IBindingCommand command : commands) {
            Pattern compiledRegexPattern = Pattern.compile(BINDINGCOMMAND_PATTERN.replace(COMMAND_SYNTAX_KEYWORD, command.getBindCommandSyntax()).replace(COMMAND_DATA_KEYWORD, command.getBindDataSyntax()));
            this.commandMap.put(compiledRegexPattern, command);
        }
        return this;
    }

    @Override
    @NotNull
    public IBindingEngine registerBindingTransformer(IBindingTransformer ... transformers) {
        for (IBindingTransformer transformer : transformers) {
            this.transformerMap.put(transformer.getTransformerName(), transformer);
        }
        return this;
    }

    private <T> IDependencyObject<T> executeBindingAttempt(@NotNull Matcher bindingCommandMatcher, @NotNull IBindingCommand command, @Nullable T defaultValue) {
        String transformerNames = bindingCommandMatcher.group(TRANSFORMER_NAME);
        if (transformerNames != null && !transformerNames.isEmpty()) {
            LinkedHashSet transformers = Arrays.stream(transformerNames.split(":")).map(this.transformerMap::get).collect(Collectors.toCollection(LinkedHashSet::new));
            IDependencyObject currentDependency = command.bind(bindingCommandMatcher, defaultValue);
            for (IBindingTransformer transformer : transformers) {
                IDependencyObject finalCurrentDependency = currentDependency;
                currentDependency = transformer.generateTransformingBind(() -> finalCurrentDependency);
            }
            return currentDependency;
        }
        return command.bind(bindingCommandMatcher, defaultValue);
    }
}

