/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.gui;

import com.ldtteam.blockout.connector.core.IGuiKey;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.util.math.Vector2d;
import org.jetbrains.annotations.NotNull;

public final class BlockOutGuiData {
    @NotNull
    private final IGuiKey key;
    @NotNull
    private IUIElementHost root;
    @NotNull
    private Vector2d guiOffset = new Vector2d(0.0, 0.0);
    @NotNull
    private Vector2d guiSize = new Vector2d(176.0, 166.0);
    @NotNull
    private Vector2d scaleFactor = new Vector2d(1.0, 1.0);
    private boolean isDrawing = false;

    public BlockOutGuiData(@NotNull IGuiKey key, @NotNull IUIElementHost root) {
        this.key = key;
        this.root = root;
    }

    @NotNull
    public IGuiKey getKey() {
        return this.key;
    }

    @NotNull
    public IUIElementHost getRoot() {
        return this.root;
    }

    public void setRoot(@NotNull IUIElementHost root) {
        this.root = root;
    }

    @NotNull
    public Vector2d getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(@NotNull Vector2d scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }

    public void setDrawing(boolean drawing) {
        this.isDrawing = drawing;
    }

    public double getGuiTop() {
        return this.guiOffset.getY();
    }

    public double getGuiLeft() {
        return this.guiOffset.getX();
    }

    public void setGuiOffset(Vector2d guiOffset) {
        this.guiOffset = guiOffset;
    }

    public void setGuiOffset(double top, double left) {
        this.guiOffset = new Vector2d(left, top);
    }

    public double getXSize() {
        return this.guiSize.getX();
    }

    public double getYSize() {
        return this.guiSize.getY();
    }

    public void setXSize(double xSize) {
        this.setGuiSize(xSize, this.getYSize());
    }

    public void setYSize(double ySize) {
        this.setGuiSize(this.getXSize(), ySize);
    }

    public void setGuiSize(@NotNull Vector2d guiSize) {
        this.guiSize = guiSize;
    }

    public void setGuiSize(double xSize, double ySize) {
        this.guiSize = new Vector2d(xSize, ySize);
    }
}

