/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.event;

import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Event<S, A> {
    private final Class<S> sourceClass;
    private final Class<A> argumentClass;
    private final List<IEventHandler<S, A>> handlers = new ArrayList<IEventHandler<S, A>>();

    public Event(Class<S> sourceClass, Class<A> argumentClass) {
        this.sourceClass = sourceClass;
        this.argumentClass = argumentClass;
    }

    public void raise(@NotNull S source, @Nullable A args) {
        this.handlers.forEach(handler -> handler.handle(source, args));
    }

    public void registerHandler(IEventHandler<?, ?> iEventHandler) {
        IEventHandler<?, ?> typedEventHandler;
        try {
            typedEventHandler = iEventHandler;
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("Failed to register event handler. Event handler either does not take sourcetype: " + this.getSourceClass().getName() + " or argument type: " + this.getArgumentClass().getName());
            return;
        }
        this.handlers.add(typedEventHandler);
    }

    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    public Class<A> getArgumentClass() {
        return this.argumentClass;
    }
}

