/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.values;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.util.set.SetUtils;
import java.util.EnumSet;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public enum Dock {
    TOP((parent, original) -> new BoundingBox(new Vector2d(0.0, 0.0), new Vector2d(parent.getSize().getX(), original.getSize().getY())), EnumSet.of(Alignment.TOP, Alignment.LEFT, Alignment.RIGHT, Alignment.NONE)),
    LEFT((parent, original) -> new BoundingBox(new Vector2d(0.0, 0.0), new Vector2d(original.getSize().getX(), parent.getSize().getY())), EnumSet.of(Alignment.TOP, Alignment.LEFT, Alignment.BOTTOM, Alignment.NONE)),
    BOTTOM((parent, original) -> new BoundingBox(new Vector2d(0.0, parent.getSize().getY() - original.getSize().getY()).nullifyNegatives(), new Vector2d(parent.getSize().getX(), original.getSize().getY())), EnumSet.of(Alignment.LEFT, Alignment.BOTTOM, Alignment.RIGHT, Alignment.NONE)),
    RIGHT((parent, original) -> new BoundingBox(new Vector2d(parent.getSize().getX() - original.getSize().getX(), 0.0).nullifyNegatives(), new Vector2d(original.getSize().getX(), parent.getSize().getY())), EnumSet.of(Alignment.TOP, Alignment.RIGHT, Alignment.BOTTOM, Alignment.NONE)),
    FULL((parent, original) -> new BoundingBox((BoundingBox)parent), EnumSet.of(Alignment.TOP, Alignment.LEFT, Alignment.RIGHT, Alignment.BOTTOM, Alignment.NONE)),
    NONE((parent, original) -> new BoundingBox((BoundingBox)original), EnumSet.of(Alignment.TOP, Alignment.LEFT, Alignment.RIGHT, Alignment.BOTTOM, Alignment.NONE));

    private final BiFunction<BoundingBox, BoundingBox, BoundingBox> boundingBoxModificationFunction;
    private final EnumSet<Alignment> validAlignments;

    private Dock(BiFunction<BoundingBox, BoundingBox, BoundingBox> boundingBoxModificationFunction, EnumSet<Alignment> validAlignments) {
        this.boundingBoxModificationFunction = boundingBoxModificationFunction;
        this.validAlignments = validAlignments;
    }

    public BoundingBox apply(@NotNull IUIElement target, @NotNull BoundingBox newBoundingBox) {
        if (!this.isAlignmentValid(target)) {
            throw new IllegalArgumentException("Target element does not contain valid alignment: " + target.getAlignment() + ". Valid: " + this.validAlignments);
        }
        return this.boundingBoxModificationFunction.apply(target.getParent().getLocalInternalBoundingBox(), newBoundingBox);
    }

    public boolean isAlignmentValid(@NotNull IUIElement element) {
        return this.isAlignmentValid(element.getAlignment());
    }

    public boolean isAlignmentValid(@NotNull EnumSet<Alignment> alignments) {
        return SetUtils.areAllIn(alignments, this.validAlignments);
    }
}

