/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.values;

import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.blockout.util.math.Vector2d;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AxisDistanceBuilder {
    private Optional<Double> left = Optional.empty();
    private Optional<Double> top = Optional.empty();
    private Optional<Double> right = Optional.empty();
    private Optional<Double> bottom = Optional.empty();

    public AxisDistanceBuilder readFromString(@NotNull Vector2d parentSize, @NotNull String string) {
        if (string.trim().isEmpty()) {
            this.setLeft(Optional.empty());
            this.setTop(Optional.empty());
            this.setRight(Optional.empty());
            this.setBottom(Optional.empty());
        } else if (string.startsWith("S")) {
            String specialInput = string.trim().replace("S", "");
            String[] components = specialInput.split(",");
            if (components.length == 1) {
                this.setWithParse(this::setLeft, parentSize.getX(), components[0]);
                this.setWithParse(this::setTop, parentSize.getY(), components[0]);
                this.setWithParse(this::setRight, parentSize.getX(), components[0]);
                this.setWithParse(this::setBottom, parentSize.getY(), components[0]);
            } else if (components.length == 2) {
                this.setWithParse(this::setLeft, parentSize.getX(), components[0]);
                this.setWithParse(this::setTop, parentSize.getY(), components[1]);
                this.setWithParse(this::setRight, parentSize.getX(), components[0]);
                this.setWithParse(this::setBottom, parentSize.getY(), components[1]);
            } else {
                Log.getLogger().error("Cannot interpret special axis distance input: " + string);
                this.setLeft(Optional.empty());
                this.setTop(Optional.empty());
                this.setRight(Optional.empty());
                this.setBottom(Optional.empty());
            }
        } else {
            String[] components = string.trim().split(",");
            if (components.length == 0 || components.length > 4) {
                this.setLeft(Optional.empty());
                this.setTop(Optional.empty());
                this.setRight(Optional.empty());
                this.setBottom(Optional.empty());
            } else {
                this.setWithParse(this::setLeft, parentSize.getX(), components[0]);
                if (components.length > 1) {
                    this.setWithParse(this::setTop, parentSize.getY(), components[1]);
                }
                if (components.length > 2) {
                    this.setWithParse(this::setRight, parentSize.getX(), components[2]);
                }
                if (components.length > 3) {
                    this.setWithParse(this::setBottom, parentSize.getY(), components[3]);
                }
            }
        }
        return this;
    }

    public AxisDistanceBuilder setLeft(Optional<Double> left) {
        this.left = left;
        return this;
    }

    public AxisDistanceBuilder setTop(Optional<Double> top) {
        this.top = top;
        return this;
    }

    public AxisDistanceBuilder setRight(Optional<Double> right) {
        this.right = right;
        return this;
    }

    public AxisDistanceBuilder setBottom(Optional<Double> bottom) {
        this.bottom = bottom;
        return this;
    }

    private void setWithParse(@NotNull Consumer<Optional<Double>> setter, @NotNull double parentSize, @NotNull String component) {
        if (component.trim().isEmpty()) {
            setter.accept(Optional.empty());
        } else if (!component.endsWith("%")) {
            try {
                setter.accept(Optional.of(Double.parseDouble(component)));
            }
            catch (Exception ex) {
                Log.getLogger().error("Failed to parse distance for axis from: " + component);
                setter.accept(Optional.empty());
            }
        } else {
            String numericalPercentage = component.replace("%", "");
            try {
                setter.accept(Optional.of(parentSize * Double.parseDouble(numericalPercentage)));
            }
            catch (Exception ex) {
                Log.getLogger().error("Failed to parse distance for axis from: " + component);
                setter.accept(Optional.empty());
            }
        }
    }

    public AxisDistance build() {
        return new AxisDistance(this.left, this.top, this.right, this.bottom);
    }
}

