/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.values;

import com.ldtteam.blockout.element.values.AxisDistanceBuilder;
import com.ldtteam.blockout.util.math.Vector2d;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class AxisDistance {
    public static final AxisDistance DEFAULT = new AxisDistance();
    @NotNull
    private Optional<Double> left;
    @NotNull
    private Optional<Double> top;
    @NotNull
    private Optional<Double> right;
    @NotNull
    private Optional<Double> bottom;

    public AxisDistance() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public AxisDistance(@NotNull Optional<Double> left, @NotNull Optional<Double> top, @NotNull Optional<Double> right, @NotNull Optional<Double> bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public AxisDistance(@NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
        this(Optional.of(left.doubleValue()), Optional.of(top.doubleValue()), Optional.of(right.doubleValue()), Optional.of(bottom.doubleValue()));
    }

    public AxisDistance move(@NotNull Vector2d delta) {
        Optional<Double> left = this.left.map(aDouble -> aDouble + delta.getX());
        Optional<Double> top = this.top.map(aDouble -> aDouble + delta.getY());
        Optional<Double> right = this.right.map(aDouble -> aDouble - delta.getX());
        Optional<Double> bottom = this.bottom.map(aDouble -> aDouble - delta.getY());
        return new AxisDistanceBuilder().setLeft(left).setTop(top).setRight(right).setBottom(bottom).build();
    }

    public int hashCode() {
        int result = this.getLeft().hashCode();
        result = 31 * result + this.getTop().hashCode();
        result = 31 * result + this.getRight().hashCode();
        result = 31 * result + this.getBottom().hashCode();
        return result;
    }

    @NotNull
    public Optional<Double> getLeft() {
        return this.left;
    }

    @NotNull
    public Optional<Double> getTop() {
        return this.top;
    }

    @NotNull
    public Optional<Double> getRight() {
        return this.right;
    }

    @NotNull
    public Optional<Double> getBottom() {
        return this.bottom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisDistance that = (AxisDistance)o;
        if (!this.getLeft().equals(that.getLeft())) {
            return false;
        }
        if (!this.getTop().equals(that.getTop())) {
            return false;
        }
        if (!this.getRight().equals(that.getRight())) {
            return false;
        }
        return this.getBottom().equals(that.getBottom());
    }

    public String toString() {
        return String.format("%s,%s,%s,%s", this.getLeft().map(Object::toString).orElse(""), this.getTop().map(Object::toString).orElse(""), this.getRight().map(Object::toString).orElse(""), this.getBottom().map(Object::toString).orElse(""));
    }
}

