/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element.values;

import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.util.Log;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public enum Alignment {
    LEFT(1),
    RIGHT(2),
    TOP(4),
    BOTTOM(8),
    NONE(0);

    private final int bitMask;

    private Alignment(int bitMask) {
        this.bitMask = bitMask;
    }

    public static int toInt(@NotNull EnumSet<Alignment> flags) {
        int value = 0;
        for (Alignment alignment : flags) {
            value |= alignment.getBitMask();
        }
        return value;
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public static EnumSet<Alignment> fromString(@NotNull String string) {
        try {
            Integer value = Integer.parseUnsignedInt(string);
            return Alignment.fromInt(value);
        }
        catch (Exception ex) {
            String[] components = string.split(",");
            EnumSet<Alignment> result = EnumSet.noneOf(Alignment.class);
            for (String component : components) {
                try {
                    result.add(Alignment.valueOf(component.trim().toUpperCase()));
                }
                catch (Exception exc) {
                    Log.getLogger().error("Failed to parse alignment: " + component);
                }
            }
            return result;
        }
    }

    @NotNull
    public static EnumSet<Alignment> fromInt(int mask) {
        if (mask == 0) {
            return EnumSet.of(NONE);
        }
        EnumSet<Alignment> result = EnumSet.noneOf(Alignment.class);
        for (Alignment alignment : Alignment.values()) {
            if ((mask & alignment.getBitMask()) <= 0) continue;
            result.add(alignment);
        }
        return result;
    }

    public boolean isActive(@NotNull IUIElement element) {
        return this.isActive(element.getAlignment());
    }

    public boolean isActive(@NotNull Set<Alignment> alignments) {
        return alignments.contains((Object)this);
    }
}

