/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element;

import com.google.common.collect.Lists;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.management.IUIManager;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IUIElementHost
extends Map<String, IUIElement>,
IUIElement {
    @NotNull
    default public IUIManager getUiManager() {
        return this.getParent().getUiManager();
    }

    public AxisDistance getPadding();

    public void setPadding(@NotNull AxisDistance var1);

    public BoundingBox getLocalInternalBoundingBox();

    public BoundingBox getAbsoluteInternalBoundingBox();

    @NotNull
    default public <T extends IUIElement> Optional<T> searchExactElementById(@NotNull String id, @NotNull Class<T> cls) {
        return this.searchExactElementById(id).filter(cls::isInstance).map(element -> element);
    }

    @NotNull
    default public Optional<IUIElement> searchExactElementById(@NotNull String id) {
        return this.searchFirstElementByPredicate(element -> element.getId().equals(id));
    }

    @NotNull
    default public Optional<IUIElement> searchFirstElementByPredicate(@NotNull Predicate<IUIElement> predicate) {
        if (predicate.test(this)) {
            return Optional.of(this);
        }
        return this.getAllCombinedChildElements().values().stream().filter(predicate).findFirst();
    }

    @NotNull
    default public Optional<IUIElement> searchDeepestElementByCoord(Vector2d localPoint) {
        return this.searchDeepestElementByCoordAndPredicate(localPoint, element -> true);
    }

    @NotNull
    default public Optional<IUIElement> searchDeepestElementByCoordAndPredicate(Vector2d localPoint, Predicate<IUIElement> predicate) {
        if (!this.getLocalBoundingBox().includes(localPoint)) {
            return Optional.empty();
        }
        ArrayList elements = new ArrayList(this.values());
        Collections.reverse(elements);
        for (IUIElement element : elements) {
            Vector2d elementLocalCoord = localPoint.move(this.getLocalBoundingBox().getLocalOrigin().invert());
            if (element instanceof IUIElementHost) {
                IUIElementHost elementHost = (IUIElementHost)element;
                Optional<IUIElement> elementResult = elementHost.searchDeepestElementByCoordAndPredicate(elementLocalCoord, predicate);
                if (!elementResult.isPresent()) continue;
                return elementResult;
            }
            if (!element.getLocalBoundingBox().includes(elementLocalCoord) || !predicate.test(element)) continue;
            return Optional.of(element);
        }
        if (predicate.test(this)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @NotNull
    default public LinkedHashMap<String, IUIElement> getAllCombinedChildElements() {
        LinkedHashMap<String, IUIElement> combinedChildren = new LinkedHashMap<String, IUIElement>(this);
        this.values().stream().filter(element -> element instanceof IUIElementHost).map(element -> (IUIElementHost)element).flatMap(iuiElementHost -> iuiElementHost.getAllCombinedChildElements().values().stream()).forEach((? super T element) -> combinedChildren.put(element.getId(), (IUIElement)element));
        return combinedChildren;
    }

    @NotNull
    default public LinkedHashMap<String, IUIElement> getAllCombinedChildElements(@NotNull Predicate<IUIElement> predicate) {
        LinkedHashMap<String, IUIElement> combinedChildren = new LinkedHashMap<String, IUIElement>(this);
        this.values().stream().filter(element -> element instanceof IUIElementHost).map(element -> (IUIElementHost)element).flatMap(iuiElementHost -> iuiElementHost.getAllCombinedChildElements().values().stream()).filter(predicate).forEach((? super T element) -> combinedChildren.put(element.getId(), (IUIElement)element));
        return combinedChildren;
    }

    default public Optional<IUIElement> getNextElement(@Nullable IUIElement element) {
        return this.getNextElement(element, iuiElement -> true);
    }

    default public Optional<IUIElement> getNextElement(@Nullable IUIElement element, Predicate<IUIElement> predicate) {
        if (element == null) {
            return Optional.of(this);
        }
        LinkedHashMap<String, IUIElement> combinedElements = this.getAllCombinedChildElements(predicate);
        int keyIndex = Lists.newArrayList(combinedElements.keySet()).indexOf(element.getId());
        if (keyIndex == -1) {
            return Optional.empty();
        }
        if (keyIndex == combinedElements.size() - 1) {
            keyIndex = -1;
        }
        return Optional.of(Lists.newArrayList(combinedElements.values()).get(++keyIndex));
    }

    default public void onPostChildUpdate(@NotNull IUpdateManager updateManager) {
    }

    @Override
    default public Vector2d getMinimalContentSize() {
        this.getParent().getUiManager().getProfiler().startSection("Minimal content size: " + this.getId());
        Vector2d currentElementSize = this.getElementSize();
        if (currentElementSize.getX() != 0.0 && currentElementSize.getY() != 0.0) {
            this.getParent().getUiManager().getProfiler().endSection();
            return currentElementSize;
        }
        this.getParent().getUiManager().getProfiler().startSection("Content size Reduction");
        Vector2d currentMinimalRequiredSizeForChildren = this.values().stream().map(IUIElement::getMinimalInternalSizeOfParent).reduce((f, s) -> f.maximize((Vector2d)s)).orElse(new Vector2d());
        this.getParent().getUiManager().getProfiler().endSection();
        this.getParent().getUiManager().getProfiler().endSection();
        return currentMinimalRequiredSizeForChildren.move(this.getPadding().getLeft().orElse(0.0), this.getPadding().getTop().orElse(0.0)).move(this.getPadding().getRight().orElse(0.0), this.getPadding().getBottom().orElse(0.0));
    }
}

