/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.element;

import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.style.core.resources.core.IResource;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IUIElement
extends IDependencyReceiver {
    public UUID getUniqueIdentifier();

    @NotNull
    public String getType();

    @NotNull
    default public <T extends IResource> T getResource(IIdentifier resourceId) throws IllegalArgumentException {
        return ProxyHolder.getInstance().getStyleManager().getResource(this.getStyleId(), resourceId);
    }

    @NotNull
    public IIdentifier getStyleId();

    public void update(@NotNull IUpdateManager var1);

    public void setDataContext(@Nullable Object var1);

    public EnumSet<Alignment> getAlignment();

    public void setAlignment(@NotNull EnumSet<Alignment> var1);

    public Dock getDock();

    public void setDock(@NotNull Dock var1);

    @NotNull
    public BoundingBox getLocalBoundingBox();

    @NotNull
    public BoundingBox getAbsoluteBoundingBox();

    public boolean isVisible();

    public void setVisible(boolean var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    default public Vector2d getMinimalInternalSizeOfParent() {
        this.getParent().getUiManager().getProfiler().startSection("Minimal internal size: " + this.getId());
        Optional<Double> marginLeft = this.getMargin().getLeft();
        Optional<Double> marginTop = this.getMargin().getTop();
        Optional<Double> marginRight = this.getMargin().getRight();
        Optional<Double> marginBottom = this.getMargin().getBottom();
        double width = this.getElementSize().getX();
        double height = this.getElementSize().getY();
        this.getParent().getUiManager().getProfiler().startSection("Minimal Content size: " + this.getId());
        Vector2d minimalContentSize = this.getMinimalContentSize();
        this.getParent().getUiManager().getProfiler().endSection();
        if (Alignment.LEFT.isActive(this) && Alignment.RIGHT.isActive(this)) {
            if (!marginLeft.isPresent() && !marginRight.isPresent()) {
                marginLeft = Optional.of(0.0);
                marginRight = Optional.of(0.0);
            } else if (!marginLeft.isPresent()) {
                marginLeft = Optional.of(0.0);
            } else if (!marginRight.isPresent()) {
                marginRight = Optional.of(0.0);
            }
        } else if (Alignment.RIGHT.isActive(this)) {
            marginLeft = Optional.of(0.0);
        }
        if (width == 0.0) {
            width = minimalContentSize.getX();
        }
        if (Alignment.TOP.isActive(this) && Alignment.BOTTOM.isActive(this)) {
            if (!marginTop.isPresent() && !marginBottom.isPresent()) {
                marginTop = Optional.of(0.0);
                marginBottom = Optional.of(0.0);
            } else if (!marginTop.isPresent()) {
                marginTop = Optional.of(0.0);
            } else if (!marginBottom.isPresent()) {
                marginBottom = Optional.of(0.0);
            }
        } else if (Alignment.BOTTOM.isActive(this)) {
            marginTop = Optional.of(0.0);
        }
        if (height == 0.0) {
            height = minimalContentSize.getY();
        }
        this.getParent().getUiManager().getProfiler().endSection();
        return new Vector2d(width + marginLeft.orElse(0.0) + marginRight.orElse(0.0), height + marginTop.orElse(0.0) + marginBottom.orElse(0.0)).nullifyNegatives();
    }

    @NotNull
    public IUIElementHost getParent();

    @Override
    @NotNull
    public String getId();

    public AxisDistance getMargin();

    public void setMargin(@NotNull AxisDistance var1);

    public Vector2d getElementSize();

    public void setElementSize(@NotNull Vector2d var1);

    default public Vector2d getMinimalContentSize() {
        return this.getElementSize();
    }

    public void setParent(@NotNull IUIElementHost var1);

    default public boolean isFocused() {
        return this.getParent().getUiManager().getFocusManager().isFocusedElement(this);
    }
}

