/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.binding.property;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.blockout.binding.property.Property;
import com.ldtteam.blockout.binding.property.StaticValueProperty;
import com.ldtteam.blockout.util.Log;
import com.ldtteam.jvoxelizer.util.tuple.ITuple;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyCreationHelper {
    private static final Cache<ITuple<Class, String>, Optional<ITuple<MethodAccess, Integer>>> GETTER_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build();
    private static final Cache<ITuple<Class, String>, Optional<ITuple<MethodAccess, Integer>>> SETTER_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build();

    private PropertyCreationHelper() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static <T> Property<T> createFromStaticValue(@Nullable T value) {
        return new StaticValueProperty<T>(value);
    }

    public static <T> Property<T> createFromOptional(@Nullable Function<Object, T> getter, @Nullable BiConsumer<Object, T> setter, @NotNull boolean requiresDataContext) {
        return PropertyCreationHelper.create(Optional.ofNullable(getter), Optional.ofNullable(setter), requiresDataContext);
    }

    public static <T> Property<T> create(@NotNull Optional<Function<Object, T>> getter, @NotNull Optional<BiConsumer<Object, T>> setter, @NotNull boolean requiresDataContext) {
        return new Property<T>(getter, setter, requiresDataContext);
    }

    public static <T> Property<T> createFromNonOptional(@NotNull Function<Object, T> getter, @NotNull BiConsumer<Object, T> setter, @NotNull boolean requiresDataContext) {
        Validate.notNull(getter);
        Validate.notNull(setter);
        return PropertyCreationHelper.create(Optional.of(getter), Optional.of(setter), requiresDataContext);
    }

    public static <T> Property<T> createFromName(@NotNull Optional<String> getSetMethodName) {
        return PropertyCreationHelper.createFromName(getSetMethodName.map(name -> "get" + name), getSetMethodName.map(name -> "set" + name));
    }

    public static <T> Property<T> createFromName(@NotNull Optional<String> getMethodName, @NotNull Optional<String> setMethodName) {
        Optional<Function<Object, T>> getter = getMethodName.map(name -> o -> {
            Class<?> clazz = o.getClass();
            Optional<ITuple<MethodAccess, Integer>> getterMethod = PropertyCreationHelper.getGetter(clazz, name);
            return getterMethod.map(method -> {
                try {
                    return ((MethodAccess)method.getFirst()).invoke(o, ((Integer)method.getSecond()).intValue(), new Object[0]);
                }
                catch (Exception e) {
                    Log.getLogger().error("Failed to reflectively access property getter.", (Throwable)e);
                    return null;
                }
            }).orElse(null);
        });
        Optional<BiConsumer<Object, T>> setter = setMethodName.map(name -> (o, t) -> {
            Class<?> clazz = o.getClass();
            Optional<ITuple<MethodAccess, Integer>> setterMethod = PropertyCreationHelper.getSetter(clazz, name);
            setterMethod.ifPresent(method -> {
                try {
                    ((MethodAccess)method.getFirst()).invoke(o, ((Integer)method.getSecond()).intValue(), new Object[]{t});
                }
                catch (Exception e) {
                    Log.getLogger().error("Failed to reflectively access property setter.", (Throwable)e);
                }
            });
        });
        return PropertyCreationHelper.create(getter, setter, true);
    }

    private static Optional<ITuple<MethodAccess, Integer>> getGetter(@Nullable Class<?> targetClass, @NotNull String getMethodName) {
        if (targetClass == null) {
            return Optional.empty();
        }
        try {
            return (Optional)GETTER_CACHE.get((Object)ITuple.create(targetClass, (Object)getMethodName), () -> {
                try {
                    MethodAccess methodAccess = MethodAccess.get((Class)targetClass);
                    Integer accessIndex = methodAccess.getIndex(getMethodName);
                    return Optional.of(ITuple.create((Object)methodAccess, (Object)accessIndex));
                }
                catch (Exception ex) {
                    return Optional.empty();
                }
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get a getter for: " + getMethodName, e);
        }
    }

    private static Optional<ITuple<MethodAccess, Integer>> getSetter(@Nullable Class<?> targetClass, @NotNull String setMethodName) {
        if (targetClass == null) {
            return Optional.empty();
        }
        try {
            return (Optional)SETTER_CACHE.get((Object)ITuple.create(targetClass, (Object)setMethodName), () -> {
                try {
                    MethodAccess methodAccess = MethodAccess.get((Class)targetClass);
                    Integer accessIndex = methodAccess.getIndex(setMethodName, 1);
                    return Optional.of(ITuple.create((Object)methodAccess, (Object)accessIndex));
                }
                catch (Exception ex) {
                    return Optional.empty();
                }
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get a setter for: " + setMethodName, e);
        }
    }
}

