/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.binding.dependency.injection;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.dependency.injection.DependentObject;
import com.ldtteam.blockout.binding.dependency.injection.IDependencyDataProvider;
import com.ldtteam.blockout.binding.dependency.injection.IInjectionController;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Log;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public final class DependencyObjectInjector {
    private DependencyObjectInjector() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static void inject(@NotNull IDependencyReceiver target, @NotNull IDependencyDataProvider provider) {
        ProxyHolder.getInstance().getReflectionManager().getFieldsForClass(target.getClass()).stream().filter(field -> field.getType().equals(IDependencyObject.class)).forEach(field -> {
            IDependencyObject current;
            try {
                current = (IDependencyObject)field.get(target);
            }
            catch (IllegalAccessException ex) {
                Log.getLogger().error("Failed to get dependency object instance. Needs to be either protected, public, or package private. Private field is not supported.");
                return;
            }
            if (current == null) {
                Log.getLogger().error("Failed to get dependency object instance. It is not set!");
                return;
            }
            Type fieldType = current.getClass().getGenericInterfaces()[0];
            if (fieldType instanceof ParameterizedType) {
                AnnotatedElement annotatedElement;
                ParameterizedType parameterizedType = (ParameterizedType)fieldType;
                Type containedType = parameterizedType.getActualTypeArguments()[0];
                String dependencyDataName = String.format("%s#%s", target.getId(), field.getName());
                if (provider.hasDependencyData(dependencyDataName)) {
                    try {
                        field.set(target, provider.get(dependencyDataName));
                    }
                    catch (Exception e) {
                        Log.getLogger().error("Failed to bind the dependency object using the provider: " + field.getName(), (Throwable)e);
                    }
                } else if (containedType instanceof AnnotatedElement && (annotatedElement = (AnnotatedElement)((Object)containedType)).isAnnotationPresent(DependentObject.class)) {
                    DependentObject dependentObject = annotatedElement.getAnnotation(DependentObject.class);
                    Object injectionControllerCandidate = null;
                    try {
                        injectionControllerCandidate = DependentObject.objectHelper.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        Log.getLogger().error("Failed to get the injection controller for: " + containedType.getTypeName());
                    }
                    if (injectionControllerCandidate instanceof IInjectionController) {
                        IInjectionController controller = injectionControllerCandidate;
                        try {
                            field.set(target, controller.get(current, provider));
                        }
                        catch (IllegalAccessException e) {
                            Log.getLogger().error("Failed to bind the dependency object using the provider: " + field.getName(), (Throwable)e);
                        }
                    }
                }
            }
        });
    }
}

