/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.binding.dependency;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class TransformingDependencyObject<T, I>
implements IDependencyObject<T> {
    private final Function<I, T> getTransformer;
    private final Function<T, I> setTransformer;
    private final IDependencyObject<I> inputDependency;
    @Nullable
    private int lastResolvedHash = 0;

    TransformingDependencyObject(IDependencyObject<I> inputDependency, Function<I, T> getTransformer, Function<T, I> setTransformer) {
        this.getTransformer = getTransformer;
        this.setTransformer = setTransformer;
        this.inputDependency = inputDependency;
    }

    @Override
    public boolean requiresDataContext() {
        return this.inputDependency.requiresDataContext();
    }

    @Override
    @Nullable
    public T get(@Nullable Object context) {
        T value = this.getTransformer.apply(this.inputDependency.get(context));
        this.lastResolvedHash = value.hashCode();
        return value;
    }

    @Override
    public void set(@Nullable Object context, @Nullable T value) {
        this.inputDependency.set(context, this.setTransformer.apply(value));
    }

    @Override
    public boolean hasChanged(@Nullable Object context) {
        T resolved = this.getTransformer.apply(this.inputDependency.get(context));
        int resolvedHash = resolved == null ? 0 : resolved.hashCode();
        return resolvedHash != this.lastResolvedHash;
    }
}

