/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.binding.dependency;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.property.Property;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyBasedDependencyObject<T>
implements IDependencyObject<T> {
    @NotNull
    private final Property<T> property;
    @Nullable
    private final T def;
    @Nullable
    private int lastResolvedHash;

    PropertyBasedDependencyObject(@NotNull Property<T> property, @Nullable T def) {
        this.property = property;
        this.def = def;
    }

    @Override
    public boolean requiresDataContext() {
        return this.property.requiresDataContext();
    }

    @Override
    @Nullable
    public T get(@Nullable Object context) {
        T value = ((Optional)this.property.apply(context)).orElse(this.def);
        this.lastResolvedHash = value != null ? value.hashCode() : 0;
        return value;
    }

    @Override
    public void set(@Nullable Object context, @Nullable T value) {
        this.property.accept(context, value);
    }

    @Override
    public boolean hasChanged(@Nullable Object context) {
        T resolved = ((Optional)this.property.apply(context)).orElse(this.def);
        int currentHash = resolved == null ? 0 : resolved.hashCode();
        return this.lastResolvedHash != currentHash;
    }
}

