/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.binding.dependency;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.PropertyBasedDependencyObject;
import com.ldtteam.blockout.binding.dependency.StaticDependencyObject;
import com.ldtteam.blockout.binding.dependency.TransformingDependencyObject;
import com.ldtteam.blockout.binding.property.Property;
import com.ldtteam.blockout.binding.property.PropertyCreationHelper;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DependencyObjectHelper {
    private DependencyObjectHelper() {
        throw new IllegalArgumentException("Utility Class");
    }

    public static <T> IDependencyObject<T> createFromValue(@Nullable T value) {
        return new StaticDependencyObject<T>(value);
    }

    public static <T, I> IDependencyObject<T> transform(IDependencyObject<I> inputDependency, Function<I, T> getTransformer, Function<T, I> setTransformer) {
        return new TransformingDependencyObject<T, I>(inputDependency, getTransformer, setTransformer);
    }

    public static <T> IDependencyObject<T> createFromGetterOnly(@NotNull Function<Object, T> dependencyGetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.create(Optional.of(dependencyGetter), Optional.empty(), true), defaultValue);
    }

    public static <T> IDependencyObject<T> createFromProperty(@NotNull Property<T> property, @Nullable T def) {
        return new PropertyBasedDependencyObject<T>(property, def);
    }

    public static <T> IDependencyObject<T> createFromGetterOnly(@NotNull Supplier<T> dependencyGetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.create(Optional.of(c -> dependencyGetter.get()), Optional.empty(), false), defaultValue);
    }

    public static <T> IDependencyObject<T> createFromSetterOnly(@NotNull BiConsumer<Object, T> dependencySetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.create(Optional.empty(), Optional.of(dependencySetter), true), defaultValue);
    }

    public static <T> IDependencyObject<T> createFromSetterOnly(@NotNull Consumer<T> dependencySetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.create(Optional.empty(), Optional.of((c, t) -> dependencySetter.accept(t)), false), defaultValue);
    }

    public static <T> IDependencyObject<T> createFromSetterAndGetter(@NotNull Function<Object, T> dependencyGetter, @NotNull BiConsumer<Object, T> dependencySetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.createFromNonOptional(dependencyGetter, dependencySetter, true), defaultValue);
    }

    public static <T> IDependencyObject<T> createFromSetterAndGetter(@NotNull Supplier<T> dependencyGetter, @NotNull Consumer<T> dependencySetter, @NotNull T defaultValue) {
        return DependencyObjectHelper.createFromProperty(PropertyCreationHelper.createFromNonOptional(c -> dependencyGetter.get(), (c, t) -> dependencySetter.accept(t), true), defaultValue);
    }
}

