/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.util;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EnchantmentUtils {
    public static boolean stackHasEnch(ItemStack stack, Enchantment enchantment) {
        return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) > 0;
    }

    public static String getWorldNameFromid(int id) {
        WorldServer[] Worlds;
        for (WorldServer world : Worlds = DimensionManager.getWorlds()) {
            if (world.field_73011_w.getDimension() != id) continue;
            return world.field_73011_w.func_186058_p().func_186065_b();
        }
        return null;
    }

    public static NBTTagCompound getTagSafe(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return new NBTTagCompound();
        }
        return stack.func_77978_p();
    }

    public static boolean isDark(EntityLivingBase e) {
        BlockPos blockpos = e.func_180425_c();
        World world = e.field_70170_p;
        int i = world.func_175671_l(blockpos);
        if (world.func_72911_I()) {
            int j = world.func_175657_ab();
            world.func_175692_b(10);
            i = world.func_175671_l(blockpos);
            world.func_175692_b(j);
        }
        return i < 8;
    }

    public static boolean isArrowAndIsLivingBase(Entity arrow, Entity victim) {
        return !(arrow instanceof EntityArrow) || !(((EntityArrow)arrow).field_70250_c instanceof EntityPlayer) || !(victim instanceof EntityLivingBase);
    }

    public static boolean isArrowinBlock(Entity arrow, Entity victim) {
        return !(arrow instanceof EntityArrow) || !(((EntityArrow)arrow).field_70250_c instanceof EntityPlayer) || victim != null;
    }

    public static void serverSafeSetVelocity(double x, double y, double z, EntityArrow arrow) {
        arrow.field_70159_w = x;
        arrow.field_70181_x = y;
        arrow.field_70179_y = z;
        if (arrow.field_70127_C == 0.0f && arrow.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            arrow.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            arrow.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            arrow.field_70127_C = arrow.field_70125_A;
            arrow.field_70126_B = arrow.field_70177_z;
            arrow.func_70012_b(arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, arrow.field_70177_z, arrow.field_70125_A);
            ObfuscationReflectionHelper.setPrivateValue(EntityArrow.class, (Object)arrow, (Object)0, (String)"field_70252_j");
        }
    }

    public static void serverSafeSetVelocity(Vec3d vec3d, EntityArrow arrow) {
        EnchantmentUtils.serverSafeSetVelocity(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, arrow);
    }
}

