/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpecialArrow
extends EntityArrow {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySpecialArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potion = PotionTypes.field_185229_a;
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();
    private boolean fixedColor;
    private int knockbackStrength;

    public EntitySpecialArrow(World worldIn) {
        super(worldIn);
    }

    public EntitySpecialArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySpecialArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    private void refreshColor() {
        this.fixedColor = false;
        this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    public void addEffect(PotionEffect effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potion == PotionTypes.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (PotionType)this.potion);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        if (this.fixedColor) {
            NBTTagCompound nbttagcompound = itemstack.func_77978_p();
            if (nbttagcompound == null) {
                nbttagcompound = new NBTTagCompound();
                itemstack.func_77982_d(nbttagcompound);
            }
            nbttagcompound.func_74768_a("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * (Double)ObfuscationReflectionHelper.getPrivateValue(EntityArrow.class, (Object)((Object)this), (String)"field_70255_ao")));
            if (this.func_70241_g()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * 0.6 / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    // empty if block
                }
            } else if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < 0.001) {
                if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        } else {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block inTile = iblockstate.func_177230_c();
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * 0.05;
            this.field_70163_u -= this.field_70181_x / (double)f2 * 0.05;
            this.field_70161_v -= this.field_70179_y / (double)f2 * 0.05;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((NBTTagCompound)compound);
        }
        for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
            this.addEffect(potioneffect);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setFixedColor(compound.func_74762_e("Color"));
        } else {
            this.refreshColor();
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        for (PotionEffect potioneffect : this.potion.func_185170_a()) {
            living.func_70690_d(new PotionEffect(potioneffect.func_188419_a(), Math.max(potioneffect.func_76459_b() / 8, 1), potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect potioneffect1 : this.customPotionEffects) {
                living.func_70690_d(potioneffect1);
            }
        }
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_185167_i) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)stack.func_77946_l());
            List collection = PotionUtils.func_185190_b((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (PotionEffect potioneffect : collection) {
                    this.customPotionEffects.add(new PotionEffect(potioneffect));
                }
            }
            if ((i = EntityTippedArrow.func_191508_b((ItemStack)stack)) == -1) {
                this.refreshColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.func_77973_b() == Items.field_151032_g) {
            this.potion = PotionTypes.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)p_191507_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

