/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentStonebound
extends Enchantment {
    public EnchantmentStonebound() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("stonebound");
        this.func_77322_b("stonebound");
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableStonebound != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableStonebound == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableStonebound != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableStonebound == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.STONEBOUND, (EntityLivingBase)(player = (EntityPlayer)event.getSource().func_76346_g())) > 0) {
            EntityLivingBase entity = event.getEntityLiving();
            ItemStack stack = player.func_184614_ca();
            float reduction = 0.02f * (float)stack.func_77952_i();
            entity.func_70691_i(reduction);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(PlayerEvent.BreakSpeed e) {
        EntityPlayer p = e.getEntityPlayer();
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.STONEBOUND, (EntityLivingBase)p) > 0) {
            float oldSpeed = e.getOriginalSpeed();
            ItemStack stack = p.func_184614_ca();
            float increase = 0.02f * (float)stack.func_77952_i();
            e.setNewSpeed(increase + oldSpeed);
        }
    }
}

