/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentSolar
extends Enchantment {
    private static EntityEquipmentSlot[] list = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET, EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND};

    public EnchantmentSolar() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, list);
        this.setRegistryName("solar");
        this.func_77322_b("solar");
    }

    public int func_77321_a(int level) {
        return 5 + 10 * (level - 1);
    }

    public int func_77317_b(int level) {
        return super.func_77321_a(level) + 25;
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.weapons.enableSolar != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.weapons.enableSolar == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.weapons.enableSolar != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.weapons.enableSolar == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void applySolar(TickEvent.PlayerTickEvent e) {
        EntityPlayer p = e.player;
        if (p.field_70170_p.field_72995_K) {
            return;
        }
        for (EntityEquipmentSlot slot : list) {
            ItemStack stack = p.func_184582_a(slot);
            int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantment.SOLAR, (ItemStack)stack);
            if (level == 0 || Math.random() / (double)level > 0.004 || EnchantmentUtils.isDark((EntityLivingBase)p)) continue;
            stack.func_77972_a(-1, (EntityLivingBase)p);
        }
    }
}

