/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.RandomEnchants;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.Coord4D;
import com.tfar.randomenchants.util.EnchantmentUtils;
import java.util.ListIterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EnchantmentGlobalTraveler
extends Enchantment {
    public static String KEY;

    public EnchantmentGlobalTraveler() {
        super(Enchantment.Rarity.VERY_RARE, RandomEnchants.TOOLSANDWEAPONS, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("global_traveler");
        this.func_77322_b("global_traveler");
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableGlobalTraveler != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableGlobalTraveler == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableGlobalTraveler != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableGlobalTraveler == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K || event.getHarvester() == null) {
            return;
        }
        ItemStack tool = EnchantmentGlobalTraveler.getItemstackToUse((EntityLivingBase)event.getHarvester(), event.getState());
        if (!EnchantmentUtils.stackHasEnch(tool, ModEnchantment.GLOBAL_TRAVELLER)) {
            return;
        }
        this.__blockHarvestDrops(tool, event);
    }

    private void __blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (!EnchantmentGlobalTraveler.getToggleState(tool)) {
            return;
        }
        NBTTagCompound nbt0 = EnchantmentUtils.getTagSafe(tool);
        if (EnchantmentUtils.stackHasEnch(tool, ModEnchantment.GLOBAL_TRAVELLER)) {
            NBTTagCompound nbt = nbt0.func_74775_l(KEY);
            Coord4D coord = Coord4D.fromNBT(nbt);
            if (coord.pos().equals((Object)event.getPos())) {
                return;
            }
            TileEntity te = coord.TE();
            if (te == null) {
                return;
            }
            IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
            if (ih == null) {
                return;
            }
            ListIterator<ItemStack> it = event.getDrops().listIterator();
            ItemStack keptSeed = ItemStack.field_190927_a;
            while (it.hasNext()) {
                it.next();
                if (event.getWorld().field_73012_v.nextFloat() > event.getDropChance()) {
                    it.remove();
                    continue;
                }
                tool.func_77973_b();
            }
            tool.func_77973_b();
            it = event.getDrops().listIterator();
            block1: while (it.hasNext()) {
                ItemStack stk = (ItemStack)it.next();
                for (int j = 0; j < ih.getSlots(); ++j) {
                    ItemStack res = ih.insertItem(j, stk, false);
                    if (res.func_190926_b()) {
                        it.remove();
                        continue block1;
                    }
                    it.set(res);
                    stk = res;
                }
            }
            if (!keptSeed.func_190926_b()) {
                event.getDrops().add(keptSeed);
            }
            event.setDropChance(1.0f);
            te.func_70296_d();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        World world0 = event.getEntity().func_130014_f_();
        if (world0.field_72995_K || event.getEntityLiving().func_110143_aJ() > 0.0f) {
            return;
        }
        ItemStack weapon = this.getWeapon(event.getSource());
        NBTTagCompound nbt0 = EnchantmentUtils.getTagSafe(weapon);
        if (EnchantmentUtils.stackHasEnch(weapon, ModEnchantment.GLOBAL_TRAVELLER)) {
            if (!EnchantmentGlobalTraveler.getToggleState(weapon)) {
                return;
            }
            if (nbt0.func_74764_b(KEY)) {
                NBTTagCompound nbt = nbt0.func_74775_l(KEY);
                Coord4D coord = Coord4D.fromNBT(nbt);
                TileEntity te = coord.TE();
                if (te == null) {
                    return;
                }
                IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
                if (ih == null) {
                    return;
                }
                ListIterator it = event.getDrops().listIterator();
                block0: while (it.hasNext()) {
                    EntityItem enti = (EntityItem)it.next();
                    ItemStack stk = enti.func_92059_d();
                    for (int j = 0; j < ih.getSlots(); ++j) {
                        ItemStack res = ih.insertItem(j, stk, false);
                        if (res.func_190926_b()) {
                            it.remove();
                            continue block0;
                        }
                        enti.func_92058_a(res);
                        stk = res;
                    }
                }
                te.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        NBTTagCompound nbt = EnchantmentUtils.getTagSafe(event.getItemStack());
        if (event.getWorld().field_72995_K || event.isCanceled() || !event.getEntityPlayer().func_70093_af() || event.getItemStack().func_190926_b() || event.getFace() == null || !EnchantmentUtils.stackHasEnch(event.getItemStack(), ModEnchantment.GLOBAL_TRAVELLER)) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te == null || te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, event.getFace()) == null) {
            return;
        }
        NBTTagCompound global = new NBTTagCompound();
        Coord4D coord = new Coord4D(event.getPos(), event.getWorld());
        coord.toNBT(global);
        global.func_74774_a("facing", (byte)event.getFace().ordinal());
        nbt.func_74782_a(KEY, (NBTBase)global);
        event.getItemStack().func_77982_d(nbt);
        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("tooltip.globalmodifier.info", new Object[]{coord.xCoord, coord.yCoord, coord.zCoord, EnchantmentUtils.getWorldNameFromid(coord.dimensionId)}));
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = source.func_76346_g()) instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_184614_ca();
        }
        return ItemStack.field_190927_a;
    }

    public static boolean getToggleState(ItemStack stack) {
        return EnchantmentUtils.stackHasEnch(stack, ModEnchantment.GLOBAL_TRAVELLER) && EnchantmentUtils.getTagSafe(stack).func_74767_n("toggle");
    }

    public static ItemStack getItemstackToUse(EntityLivingBase player, IBlockState blockState) {
        ItemStack mainhand = player.func_184614_ca();
        if (mainhand.func_190926_b() && EnchantmentGlobalTraveler.shouldUseOffhand(player, blockState, mainhand)) {
            return player.func_184592_cb();
        }
        return mainhand;
    }

    public static boolean shouldUseOffhand(EntityLivingBase player, IBlockState blockState, ItemStack tool) {
        ItemStack offhand = player.func_184592_cb();
        return !tool.func_190926_b() && !offhand.func_190926_b() && !tool.func_150998_b(blockState) && offhand.func_150998_b(blockState);
    }
}

