/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentArrowInfinite;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentExploding
extends Enchantment {
    public EnchantmentExploding() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BOW, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("exploding");
        this.func_77322_b("exploding");
    }

    public int func_77321_a(int level) {
        return 5 + 10 * (level - 1);
    }

    public int func_77317_b(int level) {
        return super.func_77321_a(level) + 25;
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.weapons.enableExploding != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.weapons.enableExploding == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.weapons.enableExploding != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantment.MULTISHOT && !(ench instanceof EnchantmentArrowInfinite);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.weapons.enableBackToTheChamber == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void arrowHit(ProjectileImpactEvent event) {
        Entity victim;
        Entity arrow = event.getEntity();
        if (EnchantmentUtils.isArrowAndIsLivingBase(arrow, victim = event.getRayTraceResult().field_72308_g)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)((EntityArrow)arrow).field_70250_c;
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.EXPLODING, (EntityLivingBase)player);
        if (level == 0) {
            return;
        }
        if (victim.field_70172_ad > 0) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            victim.field_70170_p.func_72876_a(null, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, (float)level, false);
            arrow.func_70106_y();
        }
    }
}

