/*
 * Decompiled with CFR 0.152.
 */
package wards.block;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import wards.WardsConfig;
import wards.block.BlockWard;
import wards.effect.WardEffect;
import wards.function.EnchantmentTypeHelper;

public class TileEntityWard
extends TileEntity
implements ITickable {
    private ItemStack book = ItemStack.field_190927_a;
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation;
    public float bookRotationPrev;
    public float tRot;
    private int power = 0;
    private int maxPower = 240000;
    private boolean disableAttacks = false;
    private boolean disableWard = false;
    private boolean isDisplayMode = false;
    private boolean adminMode = false;
    private NBTTagList list = new NBTTagList();

    public void setBook(ItemStack stack) {
        this.book = stack;
        this.setNBTTagList(ItemEnchantedBook.func_92110_g((ItemStack)stack));
        if (stack == ItemStack.field_190927_a) {
            this.list = new NBTTagList();
        }
        this.updateTE();
    }

    private void setNBTTagList(NBTTagList list) {
        this.list = list.func_74737_b();
    }

    public ItemStack getBook() {
        return this.book;
    }

    public boolean fuelWard(Item item) {
        if (this.power + (item == Items.field_151100_aR ? 24000 : 48000) > this.maxPower) {
            return false;
        }
        this.power += item == Items.field_151100_aR ? 24000 : 48000;
        this.updateTE();
        this.spawnParticles(EnumParticleTypes.ENCHANTMENT_TABLE, 15);
        return true;
    }

    public int getPower() {
        return this.power;
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public void consumePower() {
        if (this.power > 0) {
            boolean hasBook = false;
            if (this.book.func_77973_b() instanceof ItemEnchantedBook) {
                hasBook = true;
            }
            if (this.func_145831_w().func_82737_E() % (long)(hasBook ? 1 : 10) == 0L) {
                --this.power;
            }
        }
        this.updateTE();
    }

    public void disableAttacks(boolean bool) {
        this.updateTE();
        this.disableAttacks = bool;
        if (bool) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY, 15);
        }
    }

    public void disableWard(boolean bool) {
        this.disableWard = bool;
        this.updateTE();
        if (bool && bool) {
            this.spawnParticles(EnumParticleTypes.CRIT, 15);
        }
    }

    public void setDisplayMode(boolean bool) {
        this.isDisplayMode = bool;
        if (bool) {
            this.spawnParticles(EnumParticleTypes.ENCHANTMENT_TABLE, 15);
        }
        this.updateTE();
    }

    public boolean isDisplayMode() {
        return this.isDisplayMode;
    }

    public void setAdminMode(boolean bool) {
        this.adminMode = bool;
        if (bool) {
            this.spawnParticles(EnumParticleTypes.CLOUD, 15);
        }
        this.updateTE();
    }

    public boolean isAdminMode() {
        return this.adminMode;
    }

    public EnchantmentData[] getEnchantments() {
        if (this.book.func_77973_b() instanceof ItemEnchantedBook) {
            NBTTagList list = ItemEnchantedBook.func_92110_g((ItemStack)this.book);
            EnchantmentData[] enchants = new EnchantmentData[list.func_74745_c()];
            for (int index = 0; index < list.func_74745_c(); ++index) {
                NBTTagCompound nbttagcompound = list.func_150305_b(index);
                short id = nbttagcompound.func_74765_d("id");
                short lvl = nbttagcompound.func_74765_d("lvl");
                Enchantment enchant = Enchantment.func_185262_c((int)id);
                enchants[index] = new EnchantmentData(enchant, (int)lvl);
            }
            return enchants;
        }
        return new EnchantmentData[0];
    }

    public void func_73660_a() {
        this.rotateBook();
        if (this.book.func_77973_b() instanceof ItemEnchantedBook && this.func_145831_w().func_82737_E() % 100L == 0L) {
            if (this.canWard()) {
                EnchantmentData[] enchants = this.getEnchantments();
                if (enchants.length > 0) {
                    EnchantmentData primaryEnchant = null;
                    EnchantmentData secondaryEnchant = null;
                    if (enchants.length == 1) {
                        primaryEnchant = enchants[0];
                    } else {
                        primaryEnchant = enchants[0];
                        secondaryEnchant = enchants[1];
                        for (int i = 1; i < enchants.length; ++i) {
                            if (primaryEnchant.field_76303_c < enchants[i].field_76303_c) {
                                secondaryEnchant = primaryEnchant;
                                primaryEnchant = enchants[i];
                                continue;
                            }
                            if (secondaryEnchant.field_76303_c >= enchants[i].field_76303_c) continue;
                            secondaryEnchant = enchants[i];
                        }
                    }
                    if (secondaryEnchant != null && (primaryEnchant.field_76302_b == Enchantments.field_185308_t && secondaryEnchant.field_76302_b == Enchantments.field_185306_r || secondaryEnchant.field_76302_b == Enchantments.field_185308_t && primaryEnchant.field_76302_b == Enchantments.field_185306_r)) {
                        BlockPos pos = this.func_174877_v();
                        this.func_145831_w().func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, true);
                        InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.book);
                        this.setBook(ItemStack.field_190927_a);
                    }
                    this.wardArea(primaryEnchant, secondaryEnchant);
                }
            } else if (this.func_145831_w().field_72995_K && !this.isDisplayMode && this.func_145831_w().func_82737_E() % 20L == 0L) {
                this.spawnParticles(EnumParticleTypes.REDSTONE, 1);
            }
        }
        if (!this.isAdminMode()) {
            this.consumePower();
        }
    }

    public void wardArea(EnchantmentData ed1, EnchantmentData ed2) {
        List nearbyMobs;
        Enchantment enchant1 = ed1.field_76302_b;
        int lvl = ed1.field_76303_c;
        int range = 5 + lvl * 2;
        if (lvl > 5) {
            range = 15;
        }
        BlockPos pos1 = this.func_174877_v().func_177982_a(-range, -range, -range);
        BlockPos pos2 = this.func_174877_v().func_177982_a(range, range, range);
        AxisAlignedBB wardArea = new AxisAlignedBB(pos1, pos2);
        for (EntityPlayer player : this.func_145831_w().func_72872_a(EntityPlayer.class, wardArea)) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_70690_d(new PotionEffect((Potion)WardEffect.byEnchant(enchant1), 100, lvl - 1, false, false));
                if (ed2 != null) {
                    player.func_70690_d(new PotionEffect((Potion)WardEffect.byEnchant(ed2.field_76302_b), 100, 0, false, false));
                }
                if (EnchantmentTypeHelper.getEnchantmentType(enchant1) == EnchantmentTypeHelper.EnchantmentType.FORTITUDE) {
                    player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"absorption"), 100, 0));
                }
            }
            if (!this.func_145831_w().field_72995_K) continue;
            double xDiff = (player.field_70165_t - (double)this.func_174877_v().func_177958_n()) / 13.0;
            double yDiff = (player.field_70163_u + 0.5 - (double)this.func_174877_v().func_177956_o()) / 13.0;
            double zDiff = (player.field_70161_v - (double)this.func_174877_v().func_177952_p()) / 13.0;
            Random rand = this.func_145831_w().field_73012_v;
            for (double i = 1.0; i <= 13.0; i += 1.0) {
                double x = (double)this.func_174877_v().func_177958_n() + xDiff * i + 0.5 + (0.25 * rand.nextDouble() - 0.25 * rand.nextDouble());
                double y = (double)this.func_174877_v().func_177956_o() + yDiff * i + 0.5;
                double z = (double)this.func_174877_v().func_177952_p() + zDiff * i + 0.5 + (0.25 * rand.nextDouble() - 0.25 * rand.nextDouble());
                this.func_145831_w().func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        this.handleSpecial(enchant1, range);
        if (!this.disableAttacks && (nearbyMobs = this.func_145831_w().func_72872_a(EntityMob.class, wardArea)).size() > 0) {
            this.power -= !this.isAdminMode() ? 10 : 0;
            float damage = 0.5f * (float)lvl;
            if (ed2 != null) {
                damage += 0.5f;
            }
            for (EntityMob mob : nearbyMobs) {
                mob.func_70097_a(DamageSource.field_76376_m, damage * WardsConfig.damageMultiplier);
                this.handleEnchantAttack(mob, enchant1, lvl);
                if (!this.func_145831_w().field_72995_K) continue;
                double xDiff = (mob.field_70165_t - ((double)this.func_174877_v().func_177958_n() + 0.5)) / 14.0;
                double yDiff = (mob.field_70163_u + 0.5 - ((double)this.func_174877_v().func_177956_o() + 0.8)) / 14.0;
                double zDiff = (mob.field_70161_v - ((double)this.func_174877_v().func_177952_p() + 0.5)) / 14.0;
                EnumParticleTypes[] particles = EnchantmentTypeHelper.getParticles(enchant1);
                for (double zapCount = 1.0; zapCount <= 14.0; zapCount += 1.0) {
                    double xCoord = (double)this.func_174877_v().func_177958_n() + xDiff * zapCount;
                    double yCoord = (double)this.func_174877_v().func_177956_o() + yDiff * zapCount;
                    double zCoord = (double)this.func_174877_v().func_177952_p() + zDiff * zapCount;
                    this.func_145831_w().func_175688_a(particles[0], xCoord, yCoord, zCoord, 0.0, 0.0, 0.0, new int[0]);
                    this.func_145831_w().func_175688_a(particles[1], xCoord, yCoord, zCoord, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void handleEnchantAttack(EntityMob mob, Enchantment enchant, int level) {
        EnchantmentTypeHelper.EnchantmentType type = EnchantmentTypeHelper.getEnchantmentType(enchant);
        double x = mob.field_70165_t;
        double y = mob.field_70163_u;
        double z = mob.field_70161_v;
        if (type == EnchantmentTypeHelper.EnchantmentType.GENERIC) {
            mob.func_70097_a(DamageSource.field_76376_m, Math.min(0.5f * (float)level, 2.0f) * WardsConfig.damageMultiplier);
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.FIRE) {
            mob.func_70015_d(3 * level);
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.WATER && (mob.func_70090_H() || this.func_145831_w().func_180495_p(mob.func_180425_c()).func_185904_a() == Material.field_151586_h)) {
            mob.func_70097_a(DamageSource.field_76376_m, Math.min(1.0f * (float)level, 3.0f) * WardsConfig.damageMultiplier);
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.FROST) {
            mob.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), 100, Math.min(level - 1, 2)));
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.EXPLOSION && this.func_145831_w().field_73012_v.nextInt(15) == 0) {
            this.func_145831_w().func_72876_a((Entity)mob, x, y + 0.3, z, Math.min(1.0f * (float)level, 3.0f) * WardsConfig.damageMultiplier, false);
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.KNOCKUP) {
            mob.field_70181_x += 1.0;
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.OOF) {
            BlockPos pos = this.func_174877_v();
            Vec3d mobVec = new Vec3d(x, y, z);
            Vec3d wardVec = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            double distance = wardVec.func_72438_d(mobVec);
            Vec3d vec = new Vec3d((double)pos.func_177958_n() - x, (double)pos.func_177956_o() - y, (double)pos.func_177952_p() - z);
            mob.field_70159_w += -vec.field_72450_a / 2.5;
            mob.field_70181_x += -vec.field_72448_b / 2.0 / distance;
            mob.field_70179_y += -vec.field_72449_c / 2.5;
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.SMITE && mob.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            if (this.func_145831_w().field_73012_v.nextInt(100) == 0) {
                this.func_145831_w().func_72838_d((Entity)new EntityLightningBolt(this.func_145831_w(), x, y, z, false));
            } else {
                mob.func_70097_a(DamageSource.field_76376_m, Math.min(1.0f * (float)level, 3.0f) * WardsConfig.damageMultiplier);
            }
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.ARTHROPODS && mob.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
            mob.func_70097_a(DamageSource.field_76376_m, Math.min(1.0f * (float)level, 3.0f));
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.SWEEPING) {
            AxisAlignedBB bounds = new AxisAlignedBB(x - 1.0, y - 1.0, z - 1.0, x + 1.0, y + 1.0, z + 1.0);
            for (Entity entity : this.field_145850_b.func_72839_b((Entity)mob, bounds)) {
                if (!(entity instanceof EntityMob)) continue;
                ((EntityMob)entity).func_70097_a(DamageSource.field_76376_m, Math.min(0.5f * (float)level, 2.0f) * WardsConfig.damageMultiplier);
            }
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.EXPERIENCE && !this.func_145831_w().field_72995_K && this.func_145831_w().field_73012_v.nextInt(7) == 0) {
            EntityXPOrb orb = new EntityXPOrb(this.func_145831_w());
            orb.field_70530_e = 1;
            orb.func_70080_a(x, y, z, mob.field_70759_as, mob.field_70125_A);
            this.func_145831_w().func_72838_d((Entity)orb);
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.CURSE) {
            mob.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"wither"), 100, 0));
        }
        if (type == EnchantmentTypeHelper.EnchantmentType.LUCK && this.func_145831_w().field_73012_v.nextInt(200) == 0) {
            mob.func_70097_a(DamageSource.field_76376_m, 50.0f * WardsConfig.damageMultiplier);
        }
    }

    public void handleSpecial(Enchantment enchant, int range) {
        EnchantmentTypeHelper.EnchantmentType type = EnchantmentTypeHelper.getEnchantmentType(enchant);
        Random rand = this.func_145831_w().field_73012_v;
        if (type == EnchantmentTypeHelper.EnchantmentType.WATER) {
            BlockPos pos1 = this.func_174877_v().func_177982_a(-range, -range, -range);
            BlockPos pos2 = this.func_174877_v().func_177982_a(range, range, range);
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos1, (BlockPos)pos2)) {
                double zPos;
                double xPos;
                int i;
                IBlockState state = this.func_145831_w().func_180495_p(blockpos);
                Block block = state.func_177230_c();
                if (rand.nextInt(100) != 0) continue;
                double x = (double)blockpos.func_177958_n() + 0.5;
                double y = (double)blockpos.func_177956_o() + 0.5;
                double z = (double)blockpos.func_177952_p() + 0.5;
                if (block instanceof BlockCrops && !((BlockCrops)block).func_185525_y(state)) {
                    this.func_145831_w().func_175656_a(blockpos, ((BlockCrops)block).func_185528_e(((BlockCrops)block).func_176201_c(state) + 1));
                    if (this.func_145831_w().field_72995_K) {
                        for (i = 0; i < 5; ++i) {
                            xPos = x + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
                            zPos = z + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
                            this.func_145831_w().func_175688_a(EnumParticleTypes.WATER_SPLASH, xPos, y, zPos, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
                if (!(block instanceof BlockStem) || (Integer)state.func_177229_b((IProperty)BlockStem.field_176484_a) >= 7) continue;
                this.func_145831_w().func_175656_a(blockpos, state.func_177226_a((IProperty)BlockStem.field_176484_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockStem.field_176484_a) + 1)));
                if (!this.func_145831_w().field_72995_K) continue;
                for (i = 0; i < 5; ++i) {
                    xPos = x + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
                    zPos = z + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
                    this.func_145831_w().func_175688_a(EnumParticleTypes.WATER_SPLASH, xPos, y, zPos, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean canWard() {
        if (this.isAdminMode()) {
            return true;
        }
        if (this.disableWard || this.power <= 0 || this.isDisplayMode) {
            return false;
        }
        boolean flag = true;
        int range = 15;
        BlockPos pos1 = this.func_174877_v().func_177982_a(-range, -range, -range);
        BlockPos pos2 = this.func_174877_v().func_177982_a(range, range, range);
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos1, (BlockPos)pos2)) {
            if (Objects.equal((Object)blockpos, (Object)this.func_174877_v()) || !(this.func_145831_w().func_180495_p(blockpos).func_177230_c() instanceof BlockWard) || !(((TileEntityWard)this.func_145831_w().func_175625_s(blockpos)).getBook().func_77973_b() instanceof ItemEnchantedBook) || (flag = false) || !this.func_145831_w().field_72995_K) continue;
            double xDiff = (double)(blockpos.func_177958_n() - this.func_174877_v().func_177958_n()) / 8.0;
            double yDiff = (double)(blockpos.func_177956_o() - this.func_174877_v().func_177956_o()) / 8.0;
            double zDiff = (double)(blockpos.func_177952_p() - this.func_174877_v().func_177952_p()) / 8.0;
            for (double i = 1.0; i <= 8.0; i += 1.0) {
                double x = (double)this.func_174877_v().func_177958_n() + xDiff * i + 0.5;
                double y = (double)this.func_174877_v().func_177956_o() + yDiff * i + 0.5;
                double z = (double)this.func_174877_v().func_177952_p() + zDiff * i + 0.5;
                this.func_145831_w().func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return flag;
    }

    public void spawnParticles(EnumParticleTypes particle, int amount) {
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.8;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        for (int i = 0; i < amount; ++i) {
            double xPos = x + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
            double zPos = z + 0.5 * this.func_145831_w().field_73012_v.nextDouble() - 0.5 * this.func_145831_w().field_73012_v.nextDouble();
            this.func_145831_w().func_175688_a(particle, xPos, y, zPos, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void rotateBook() {
        float f2;
        Random rand = this.func_145831_w().field_73012_v;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        this.tRot += 0.02f;
        this.bookSpread = this.canWard() || this.isDisplayMode ? (this.bookSpread += 0.1f) : (this.bookSpread -= 0.1f);
        if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
            float f1 = this.flipT;
            do {
                this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
            } while (f1 == this.flipT);
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.bookRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.bookRotation += f2 * 0.4f;
        this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)(1.0f * (float)((double)this.power / (double)this.maxPower)));
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Item")) {
            this.book = new ItemStack(Item.func_111206_d((String)compound.func_74779_i("Item")), 1);
            this.list = (NBTTagList)compound.func_74781_a("Enchantments");
            for (int i = 0; i < this.list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = this.list.func_150305_b(i);
                short id = nbttagcompound.func_74765_d("id");
                short lvl = nbttagcompound.func_74765_d("lvl");
                Enchantment enchant = Enchantment.func_185262_c((int)id);
                EnchantmentData data = new EnchantmentData(enchant, (int)lvl);
                ItemEnchantedBook.func_92115_a((ItemStack)this.book, (EnchantmentData)data);
            }
        } else {
            this.book = ItemStack.field_190927_a;
        }
        if (compound.func_74764_b("Power")) {
            this.power = compound.func_74762_e("Power");
        }
        if (compound.func_74764_b("DisableAttacks")) {
            this.disableAttacks = compound.func_74767_n("DisableAttacks");
        }
        if (compound.func_74764_b("DisableWard")) {
            this.disableWard = compound.func_74767_n("DisableWard");
        }
        if (compound.func_74764_b("Display")) {
            this.isDisplayMode = compound.func_74767_n("Display");
        }
        if (compound.func_74764_b("Admin")) {
            this.adminMode = compound.func_74767_n("Admin");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.book != ItemStack.field_190927_a) {
            ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.book.func_77973_b());
            compound.func_74778_a("Item", resource == null ? "" : resource.toString());
            compound.func_74782_a("Enchantments", (NBTBase)this.list);
        }
        compound.func_74768_a("Power", this.power);
        compound.func_74757_a("DisableAttacks", this.disableAttacks);
        compound.func_74757_a("DisableWard", this.disableWard);
        compound.func_74757_a("Display", this.isDisplayMode);
        compound.func_74757_a("Admin", this.adminMode);
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 7, this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateTE() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        this.func_145831_w().func_180497_b(this.func_174877_v(), this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }
}

