/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.inv.network;

import CoroUtil.difficulty.DifficultyInfoPlayer;
import CoroUtil.forge.CULog;
import com.corosus.inv.InvasionNetworkHandler;
import com.corosus.inv.block.TileEntitySacrifice;
import com.corosus.inv.config.ConfigInvasion;
import com.corosus.inv.network.MessageSendDifficultyData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequestDifficultyData
implements IMessage {
    private int dimID = 0;
    private BlockPos tileEntityPos = new BlockPos(0, 0, 0);

    public MessageRequestDifficultyData() {
    }

    public MessageRequestDifficultyData(World world, BlockPos tileEntityPos) {
        this.tileEntityPos = tileEntityPos;
        this.dimID = world.field_73011_w.getDimension();
    }

    public void fromBytes(ByteBuf buf) {
        this.dimID = buf.readInt();
        this.tileEntityPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimID);
        buf.writeInt(this.tileEntityPos.func_177958_n());
        buf.writeInt(this.tileEntityPos.func_177956_o());
        buf.writeInt(this.tileEntityPos.func_177952_p());
    }

    public static class MessageHandler
    implements IMessageHandler<MessageRequestDifficultyData, IMessage> {
        public IMessage onMessage(MessageRequestDifficultyData message, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                EntityPlayer player;
                TileEntity tEnt;
                WorldServer world = DimensionManager.getWorld((int)message.dimID);
                if (world != null && (tEnt = world.func_175625_s(message.tileEntityPos)) instanceof TileEntitySacrifice && (player = ((TileEntitySacrifice)tEnt).getPlayer()) instanceof EntityPlayerMP) {
                    CULog.dbg((String)("request dps from " + player.func_70005_c_()));
                    DifficultyInfoPlayer difficultyInfoPlayer = new DifficultyInfoPlayer(message.tileEntityPos);
                    difficultyInfoPlayer.updateData(player, ConfigInvasion.Sacrifice_CountNeeded, ConfigInvasion.Sacrifice_CountNeeded_Multiplier);
                    ((TileEntitySacrifice)tEnt).setDifficultyInfoPlayer(difficultyInfoPlayer);
                    InvasionNetworkHandler.INSTANCE.sendTo((IMessage)new MessageSendDifficultyData(difficultyInfoPlayer, (TileEntitySacrifice)tEnt), (EntityPlayerMP)player);
                }
            });
            return null;
        }
    }
}

