/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.inv;

import CoroUtil.ai.tasks.EntityAIChaseFromFar;
import CoroUtil.ai.tasks.EntityAINearestAttackablePlayerOmniscience;
import CoroUtil.ai.tasks.TaskDigTowardsTarget;
import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.difficulty.DifficultyQueryContext;
import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.difficulty.data.DataCondition;
import CoroUtil.difficulty.data.DeserializerAllJson;
import CoroUtil.difficulty.data.DifficultyDataReader;
import CoroUtil.difficulty.data.conditions.ConditionContext;
import CoroUtil.difficulty.data.conditions.ConditionDifficulty;
import CoroUtil.difficulty.data.conditions.ConditionGameStages;
import CoroUtil.difficulty.data.conditions.ConditionInvasionNumber;
import CoroUtil.difficulty.data.conditions.ConditionInvasionRate;
import CoroUtil.difficulty.data.conditions.ConditionModLoaded;
import CoroUtil.difficulty.data.conditions.ConditionRandom;
import CoroUtil.difficulty.data.spawns.DataMobSpawnsTemplate;
import CoroUtil.forge.CULog;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilCrossMod;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilWorldTime;
import CoroUtil.util.EnumSpawnPlacementType;
import com.corosus.inv.InvLog;
import com.corosus.inv.Invasion;
import com.corosus.inv.InvasionEntitySpawn;
import com.corosus.inv.capabilities.PlayerDataInstance;
import com.corosus.inv.config.ConfigAdvancedOptions;
import com.corosus.inv.config.ConfigInvasion;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.Loader;

public class InvasionManager {
    public static boolean invasionOnThisNight_Last = false;
    public static boolean isDayLast = false;

    public static boolean canPlayerSkipInvasion(EntityPlayer player) {
        World world = player.field_70170_p;
        boolean skipped = player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkipping);
        if (!skipped && InvasionManager.isInvasionTonight(world) && !CoroUtilWorldTime.isNightPadded((World)world)) {
            int skipCount = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCount);
            if (ConfigInvasion.maxConsecutiveInvasionSkips == -1 || skipCount < ConfigInvasion.maxConsecutiveInvasionSkips) {
                return true;
            }
        }
        return false;
    }

    public static boolean skipNextInvasionForPlayer(EntityPlayer player) {
        World world = player.field_70170_p;
        boolean skipped = player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkipping);
        if (!skipped) {
            if (InvasionManager.isInvasionTonight(world)) {
                if (!CoroUtilWorldTime.isNightPadded((World)world)) {
                    int skipCount = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCount);
                    if (ConfigInvasion.maxConsecutiveInvasionSkips == -1 || skipCount < ConfigInvasion.maxConsecutiveInvasionSkips) {
                        player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkipping, true);
                        player.getEntityData().func_74768_a(DynamicDifficulty.dataPlayerInvasionSkipCount, ++skipCount);
                        int skipCountAllTime = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier) + 1;
                        player.getEntityData().func_74768_a(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier, skipCountAllTime);
                        player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.Invasion_Message_skipping, skipCount)));
                        return true;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.Invasion_Message_skippedTooMany, ConfigInvasion.maxConsecutiveInvasionSkips)));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_tooLate));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_notInvasionNight));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_alreadySkipping));
        }
        return false;
    }

    public static void tickPlayer(EntityPlayer player) {
        if (ConfigInvasion.preventSleepDuringInvasions && InvasionManager.shouldLockOutFeaturesForPossibleActiveInvasion(player.field_70170_p) && player.func_70608_bn()) {
            player.func_70999_a(true, true, false);
            player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_cantSleep));
        }
    }

    public static void tickPlayerEverywhere(EntityPlayer player) {
        if (ConfigInvasion.forcePlayersToOverworldDuringInvasion && CoroUtilWorldTime.isNightPadded((World)player.field_70170_p) && InvasionManager.isInvasionTonight(player.field_70170_p) && !InvasionManager.isPlayerSkippingInvasion(player)) {
            PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
            if (player.field_71093_bK == 0) {
                storage.ticksNotInOverworld = 0;
            } else {
                if (ConfigInvasion.forcePlayersToOverworldDuringInvasion_TickDelay > 0) {
                    if (storage.ticksNotInOverworld == 0 && !ConfigInvasion.forcePlayersToOverworldDuringInvasion_FirstWarningMessage.equals("")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.forcePlayersToOverworldDuringInvasion_FirstWarningMessage, ConfigInvasion.forcePlayersToOverworldDuringInvasion_TickDelay / 20)));
                    }
                    if (ConfigInvasion.forcePlayersToOverworldDuringInvasion_TickDelay - storage.ticksNotInOverworld == 200 && !ConfigInvasion.forcePlayersToOverworldDuringInvasion_FinalWarningMessage.equals("")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.forcePlayersToOverworldDuringInvasion_FinalWarningMessage));
                    }
                }
                CULog.dbg((String)("time: " + player.field_70170_p.func_82737_E() + " - " + storage.ticksNotInOverworld));
                ++storage.ticksNotInOverworld;
                if (storage.ticksNotInOverworld >= ConfigInvasion.forcePlayersToOverworldDuringInvasion_TickDelay && player instanceof EntityPlayerMP && (player = (EntityPlayer)player.func_184204_a(0)) != null) {
                    BlockPos spawnPos = player.getBedLocation(0);
                    if (spawnPos != null && (spawnPos = EntityPlayer.func_180467_a((World)((EntityPlayerMP)player).field_70170_p, (BlockPos)spawnPos, (boolean)false)) == null) {
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(0, 0.0f));
                    }
                    if (spawnPos == null) {
                        CULog.dbg((String)"force tp, no bed location found, reverting to world spawn");
                        spawnPos = player.field_70170_p.field_73011_w.getRandomizedSpawnPoint();
                    }
                    CULog.dbg((String)("spawnpoint to use: " + spawnPos));
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
                    if (!ConfigInvasion.forcePlayersToOverworldDuringInvasion_TPMessage.equals("")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.forcePlayersToOverworldDuringInvasion_TPMessage));
                    }
                }
            }
        }
    }

    public static void tickPlayerSlowPre(EntityPlayer player) {
        long ticksPlayed;
        int dayNum;
        if (ConfigInvasion.invasionCountingPerPlayer && (dayNum = (int)((ticksPlayed = player.getEntityData().func_74763_f(DynamicDifficulty.dataPlayerServerTicks)) / (long)CoroUtilWorldTime.getDayLength()) + 1) < ConfigInvasion.firstInvasionNight) {
            player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon, true);
        }
    }

    public static void tickPlayerSlow(EntityPlayer player) {
        try {
            boolean isDay;
            World world = player.field_70170_p;
            Vec3d posVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight()), player.field_70161_v);
            BlockCoord pos = new BlockCoord(MathHelper.func_76128_c((double)posVec.field_72450_a), MathHelper.func_76128_c((double)posVec.field_72448_b), MathHelper.func_76128_c((double)posVec.field_72449_c));
            float difficultyScale = DynamicDifficulty.getDifficultyScaleAverage((World)world, (EntityPlayer)player, (BlockCoord)pos);
            PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
            long dayNumber = world.func_72820_D() / (long)CoroUtilWorldTime.getDayLength() + 1L;
            boolean invasionActive = false;
            boolean activeBool = storage.dataPlayerInvasionActive;
            boolean skippingBool = InvasionManager.isPlayerSkippingInvasion(player);
            boolean invasionOnThisNight = InvasionManager.isInvasionTonight(world);
            if (invasionOnThisNight != invasionOnThisNight_Last) {
                InvLog.dbg("invasionOnThisNight: " + invasionOnThisNight);
                invasionOnThisNight_Last = invasionOnThisNight;
            }
            boolean bl = isDay = !CoroUtilWorldTime.isNightPadded((World)world);
            if (isDay != isDayLast) {
                InvLog.dbg("world.isDaytime(): " + isDay + ", time: " + world.func_72820_D() + ", timemod: " + world.func_72820_D() % (long)CoroUtilWorldTime.getDayLength());
                isDayLast = isDay;
            }
            if (invasionOnThisNight && isDay && !storage.dataPlayerInvasionWarned && !storage.dataPlayerInvasionHappenedThisDay) {
                if (player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon)) {
                    if (InvasionManager.isAnyoneBeingInvadedTonight(player.field_70170_p) && !ConfigInvasion.Invasion_Message_startsTonightButNotYou.equals("")) {
                        player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.Invasion_Message_startsTonightButNotYou, ConfigInvasion.firstInvasionNight)));
                    }
                } else if (!ConfigInvasion.Invasion_Message_startsTonight.equals("")) {
                    player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_startsTonight));
                }
                storage.dataPlayerInvasionWarned = true;
            }
            if (!invasionOnThisNight) {
                storage.dataPlayerInvasionHappenedThisDay = false;
            }
            if (invasionOnThisNight && !isDay) {
                storage.dataPlayerInvasionHappenedThisDay = true;
                invasionActive = true;
                if (!activeBool) {
                    if (!skippingBool) {
                        InvLog.dbg("attempting to start invasion for player: " + player.func_70005_c_());
                        InvasionManager.invasionStart(player, difficultyScale);
                    } else {
                        storage.dataPlayerInvasionActive = true;
                        if (player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkipping)) {
                            if (!ConfigInvasion.Invasion_Message_startedButSkippedForYou.equals("")) {
                                player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_startedButSkippedForYou));
                            }
                        } else if (player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon) && InvasionManager.isAnyoneBeingInvadedTonight(player.field_70170_p) && !ConfigInvasion.Invasion_Message_startedButSkippedForYouTooSoon.equals("")) {
                            player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.Invasion_Message_startedButSkippedForYouTooSoon, ConfigInvasion.firstInvasionNight)));
                        }
                    }
                }
            } else {
                invasionActive = false;
                if (activeBool) {
                    if (!skippingBool) {
                        player.getEntityData().func_74768_a(DynamicDifficulty.dataPlayerInvasionSkipCount, 0);
                        if (ConfigInvasion.Sacrifice_CountNeeded_Multiplier_ResetOnInvasionNoSkip) {
                            player.getEntityData().func_74768_a(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier, 0);
                        }
                    }
                    InvasionManager.invasionStopReset(player);
                }
            }
            if (!invasionOnThisNight) {
                storage.dataPlayerInvasionWarned = false;
                player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkipping, false);
                player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon, false);
            }
            if (invasionActive && !skippingBool) {
                if (world.func_82737_E() % (long)ConfigAdvancedOptions.aiTickRateEnhance == 0L && ConfigAdvancedOptions.enhanceAllMobsOfSpawnedTypesForOmniscience) {
                    boolean debugTPSSpike = false;
                    if (debugTPSSpike) {
                        player.func_145747_a((ITextComponent)new TextComponentString("enhancing extra mobs with omniscience"));
                        CULog.dbg((String)"enhancing extra mobs with omniscience");
                    }
                    int range = ConfigAdvancedOptions.aiOmniscienceRange;
                    List listEnts = world.func_72872_a(EntityCreature.class, new AxisAlignedBB((double)pos.posX, (double)pos.posY, (double)pos.posZ, (double)pos.posX, (double)pos.posY, (double)pos.posZ).func_72314_b((double)range, (double)range, (double)range));
                    List<Class> listClassesSpawned = storage.getSpawnableClasses();
                    for (EntityCreature ent : listEnts) {
                        boolean shouldEnhanceEntity = listClassesSpawned.contains(ent.getClass());
                        boolean hostileMobsOnly = true;
                        if (!shouldEnhanceEntity || hostileMobsOnly && !(ent instanceof EntityMob)) continue;
                        ent.getEntityData().func_74757_a(UtilEntityBuffs.dataEntityBuffed, true);
                        ent.getEntityData().func_74757_a(UtilEntityBuffs.dataEntityBuffed_AI_Omniscience, true);
                        ent.getEntityData().func_74772_a(UtilEntityBuffs.dataEntityBuffed_LastTimePathfindLongDist, ent.field_70170_p.func_82737_E() + (long)(ent.func_145782_y() % 20));
                        if (!UtilEntityBuffs.hasTask((EntityCreature)ent, EntityAINearestAttackablePlayerOmniscience.class, (boolean)true)) {
                            UtilEntityBuffs.addTask((EntityCreature)ent, EntityAINearestAttackablePlayerOmniscience.class, (int)10, (boolean)true);
                        }
                        if (UtilEntityBuffs.hasTask((EntityCreature)ent, EntityAIChaseFromFar.class, (boolean)false)) continue;
                        UtilEntityBuffs.addTask((EntityCreature)ent, EntityAIChaseFromFar.class, (int)4, (boolean)false);
                    }
                }
                if (world.func_82737_E() % (long)ConfigAdvancedOptions.aiTickRateSpawning == 0L) {
                    InvasionManager.spawnNewMobFromProfile((EntityLivingBase)player, difficultyScale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void tickSpawning(EntityPlayer player, float difficulty) {
    }

    public static void invasionStart(EntityPlayer player, float difficultyScale) {
        PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        InvLog.dbg("resetInvasion() for start");
        storage.resetInvasion();
        storage.dataPlayerInvasionActive = true;
        storage.setDifficultyForInvasion(difficultyScale);
        ++storage.lastWaveNumber;
        int waveNumberToUse = ConfigInvasion.invasionCountingPerPlayer ? storage.lastWaveNumber : InvasionManager.getInvasionNumber(player.field_70170_p);
        DataMobSpawnsTemplate profile = InvasionManager.chooseInvasionProfile(player, new DifficultyQueryContext(ConditionContext.TYPE_INVASION, waveNumberToUse, difficultyScale));
        if (profile != null) {
            storage.initNewInvasion(profile);
        }
        if (profile != null && !profile.wave_message.equals("<NULL>")) {
            if (!profile.wave_message.equals("")) {
                player.func_145747_a((ITextComponent)new TextComponentString(profile.wave_message));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_started));
        }
        float buffBase = 0.5f;
        float skipCount = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCount);
        float finalCalc = buffBase * skipCount;
        InvLog.dbg("buffing invasion, inv count: " + skipCount + ", actual buff: " + finalCalc);
        DynamicDifficulty.setInvasionSkipBuff((EntityPlayer)player, (float)finalCalc);
    }

    public static DataMobSpawnsTemplate getInvasionTestData(EntityPlayer player, DifficultyQueryContext context) {
        PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        DataMobSpawnsTemplate profile = InvasionManager.chooseInvasionProfile(player, context);
        return profile;
    }

    public static void invasionStopReset(EntityPlayer player) {
        PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        if (!InvasionManager.isPlayerSkippingInvasion(player) && !ConfigInvasion.Invasion_Message_ended.equals("")) {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format(ConfigInvasion.Invasion_Message_ended, ConfigInvasion.invadeEveryXDays)));
        }
        storage.dataPlayerInvasionActive = false;
        storage.dataPlayerInvasionWarned = false;
        InvLog.dbg("resetInvasion() for stop reset");
        storage.resetInvasion();
        player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkipping, false);
        player.getEntityData().func_74757_a(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon, false);
        DynamicDifficulty.setInvasionSkipBuff((EntityPlayer)player, (float)0.0f);
    }

    public static boolean spawnNewMobFromProfile(EntityLivingBase player, float difficultyScale) {
        PlayerDataInstance storage = (PlayerDataInstance)player.getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        int minDist = ConfigAdvancedOptions.spawnRangeMin;
        int maxDist = ConfigAdvancedOptions.spawnRangeMax;
        int range = maxDist * 2;
        Random rand = player.field_70170_p.field_73012_v;
        InvasionEntitySpawn randomEntityList = storage.getRandomEntityClassToSpawn();
        int tryCachedCaveSpotThreshold = 300;
        int tryWaterSurfaceAreasThreshold = 300;
        if (randomEntityList != null) {
            for (int tries = 0; tries < ConfigAdvancedOptions.attemptsPerSpawn; ++tries) {
                block33: {
                    boolean skipDarknessCheck;
                    IBlockState state;
                    BlockPos pos;
                    ++storage.triesSinceWorkingAnySpawn;
                    int tryX = MathHelper.func_76128_c((double)player.field_70165_t) - range / 2 + rand.nextInt(range);
                    int tryZ = MathHelper.func_76128_c((double)player.field_70161_v) - range / 2 + rand.nextInt(range);
                    int tryY = MathHelper.func_76128_c((double)player.field_70163_u) - range / 2 + rand.nextInt(range);
                    int surfaceY = player.field_70170_p.func_175645_m(new BlockPos(tryX, 0, tryZ)).func_177956_o();
                    --surfaceY;
                    double distXZ = player.func_70011_f((double)tryX, player.field_70163_u, (double)tryZ);
                    if (distXZ < (double)minDist || distXZ > (double)maxDist) continue;
                    boolean requireSolidGround = true;
                    boolean allowWaterSurfaceSpawn = false;
                    if (randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.WATER || randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.AIR) {
                        requireSolidGround = false;
                    }
                    int yToUse = surfaceY;
                    boolean caveSpawn = false;
                    if (randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.GROUND) {
                        if (player.field_70163_u + 10.0 > (double)surfaceY) {
                            yToUse = surfaceY;
                        } else {
                            yToUse = tryY;
                            caveSpawn = true;
                        }
                    } else if (randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.CAVE) {
                        caveSpawn = true;
                        yToUse = tryY;
                    } else if (randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.SURFACE) {
                        caveSpawn = false;
                        yToUse = surfaceY;
                    } else if (randomEntityList.spawnProfile.spawnType != EnumSpawnPlacementType.WATER ? randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.AIR && (!player.field_70170_p.func_175623_d(pos = new BlockPos(tryX, yToUse = tryY, tryZ)) || !player.field_70170_p.func_175623_d(pos.func_177984_a())) : (state = player.field_70170_p.func_180495_p(pos = new BlockPos(tryX, yToUse = tryY, tryZ))).func_185904_a() != Material.field_151586_h || player.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151586_h || player.field_70170_p.func_180495_p(pos.func_177984_a()).func_185915_l()) continue;
                    if (caveSpawn && storage.triesSinceWorkingCaveSpawn > tryCachedCaveSpotThreshold && storage.listGoodCavePositions.size() > 0) {
                        CULog.dbg((String)"trying cached cave spot to spawn with");
                        pos = storage.listGoodCavePositions.get(rand.nextInt(storage.listGoodCavePositions.size() - 1));
                        tryX = pos.func_177958_n();
                        yToUse = pos.func_177956_o();
                        tryZ = pos.func_177952_p();
                    }
                    if (!caveSpawn && storage.triesSinceWorkingSolidGroundSpawn > tryWaterSurfaceAreasThreshold) {
                        allowWaterSurfaceSpawn = true;
                    }
                    boolean isWaterSurfaceSpawned = false;
                    if (requireSolidGround) {
                        ++storage.triesSinceWorkingSolidGroundSpawn;
                        if (!CoroUtilEntity.canSpawnMobOnGround((World)player.field_70170_p, (int)tryX, (int)yToUse, (int)tryZ)) {
                            if (!allowWaterSurfaceSpawn) continue;
                            CULog.dbg((String)"trying surface water to spawn with");
                            BlockPos pos2 = new BlockPos(tryX, surfaceY, tryZ);
                            IBlockState state2 = player.field_70170_p.func_180495_p(pos2);
                            if (state2.func_185904_a() != Material.field_151586_h || !CoroUtilBlock.isAir((Block)player.field_70170_p.func_180495_p(pos2.func_177984_a()).func_177230_c())) continue;
                            isWaterSurfaceSpawned = true;
                            --storage.triesSinceWorkingSolidGroundSpawn;
                        }
                    }
                    if (ConfigAdvancedOptions.failedTriesBeforeAllowingSpawnInLitAreas != -1 && !storage.allowSpawnInLitAreas && storage.triesSinceWorkingAnySpawn > ConfigAdvancedOptions.failedTriesBeforeAllowingSpawnInLitAreas) {
                        CULog.dbg((String)("couldnt find a dark area to spawn for " + ConfigAdvancedOptions.failedTriesBeforeAllowingSpawnInLitAreas + " tries, allowing spawning in lit areas now"));
                        storage.allowSpawnInLitAreas = true;
                    }
                    boolean bl = skipDarknessCheck = storage.allowSpawnInLitAreas || !ConfigAdvancedOptions.mobsMustSpawnInDarkness;
                    if (caveSpawn) {
                        ++storage.triesSinceWorkingCaveSpawn;
                        if (!CoroUtilEntity.isInDarkCave((World)player.field_70170_p, (int)tryX, (int)yToUse, (int)tryZ, (boolean)true, (boolean)skipDarknessCheck)) {
                            continue;
                        }
                    } else if (!skipDarknessCheck && player.field_70170_p.func_175671_l(new BlockPos(tryX, yToUse + 1, tryZ)) >= 6) continue;
                    try {
                        Class classToSpawn;
                        String spawnStr = (String)randomEntityList.spawnProfile.entities.get(rand.nextInt(randomEntityList.spawnProfile.entities.size()));
                        String spawn = CoroUtilEntity.getEntityNameStringFromNBTLoadedName((String)spawnStr);
                        String spawnStrNBT = CoroUtilEntity.getEntityNBTStringFromNBTLoadedName((String)spawnStr);
                        if (spawn.equals("minecraft:bat")) {
                            spawn = "coroutil:bat_smart";
                        }
                        if ((classToSpawn = CoroUtilEntity.getClassFromRegistry((String)spawn)) != null) {
                            if (EntityCreature.class.isAssignableFrom(classToSpawn)) {
                                EntityCreature ent = null;
                                NBTTagCompound spawnNBT = null;
                                boolean handleSpawning = true;
                                if (spawnStrNBT != "") {
                                    handleSpawning = false;
                                    try {
                                        spawnNBT = JsonToNBT.func_180713_a((String)spawnStrNBT);
                                        spawnNBT.func_74778_a("id", spawn);
                                        spawnNBT.func_74757_a(UtilEntityBuffs.dataEntityInitialSpawn, true);
                                    }
                                    catch (NBTException nbtexception) {
                                        throw new CommandException("commands.summon.tagError", new Object[]{nbtexception.getMessage()});
                                    }
                                    ent = (EntityCreature)AnvilChunkLoader.func_186054_a((NBTTagCompound)spawnNBT, (World)player.field_70170_p, (double)tryX, (double)(yToUse + 1), (double)tryZ, (boolean)true);
                                } else {
                                    ent = (EntityCreature)classToSpawn.getConstructor(World.class).newInstance(player.field_70170_p);
                                }
                                ent.func_70107_b((double)tryX, (double)(yToUse + 1), (double)tryZ);
                                ent.func_180482_a(ent.field_70170_p.func_175649_E(new BlockPos((Entity)ent)), (IEntityLivingData)null);
                                ent.getEntityData().func_74757_a(UtilEntityBuffs.dataEntityWaveSpawned, true);
                                ent.getEntityData().func_74757_a(TaskDigTowardsTarget.dataUseInvasionRules, true);
                                ent.getEntityData().func_74778_a(UtilEntityBuffs.dataEntityBuffed_PlayerSpawnedFor, player.func_70005_c_());
                                UtilEntityBuffs.registerAndApplyCmods((EntityCreature)ent, (List)randomEntityList.spawnProfile.cmods, (float)difficultyScale);
                                if (handleSpawning) {
                                    ent.getEntityData().func_74757_a(UtilEntityBuffs.dataEntityInitialSpawn, true);
                                    player.field_70170_p.func_72838_d((Entity)ent);
                                }
                                ent.getEntityData().func_74757_a(UtilEntityBuffs.dataEntityInitialSpawn, false);
                                if (ent instanceof EntityZombie) {
                                    ((EntityZombie)ent).func_82227_f(false);
                                }
                                ++randomEntityList.spawnCountCurrent;
                                storage.triesSinceWorkingAnySpawn = 0;
                                if (caveSpawn) {
                                    storage.triesSinceWorkingCaveSpawn = 0;
                                    BlockPos pos3 = new BlockPos(tryX, yToUse, tryZ);
                                    if (!storage.listGoodCavePositions.contains(pos3)) {
                                        CULog.dbg((String)("found good cave spot, adding: " + pos3));
                                        storage.listGoodCavePositions.add(pos3);
                                    }
                                }
                                if (requireSolidGround && !isWaterSurfaceSpawned) {
                                    storage.triesSinceWorkingSolidGroundSpawn = 0;
                                }
                                InvLog.dbg("Spawned " + randomEntityList.spawnCountCurrent + " at " + new BlockPos(tryX, yToUse, tryZ) + " mobs now: " + ent.func_70005_c_() + (randomEntityList.spawnProfile.spawnType == EnumSpawnPlacementType.GROUND ? (caveSpawn ? " cavespawned" : " surfacespawned") : "") + " " + randomEntityList.spawnProfile.spawnType);
                                break block33;
                            }
                            InvLog.err("only EntityCreature extended entities are supported, couldnt spawn: " + spawn);
                            break block33;
                        }
                        InvLog.err("could not find registered class for entity name: " + spawn);
                    }
                    catch (Exception e) {
                        InvLog.err("HW_Invasions: error spawning invasion entity: ");
                        e.printStackTrace();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isInvasionTonight(World world) {
        int dayAdjust = 0;
        if (!ConfigInvasion.invasionCountingPerPlayer) {
            dayAdjust = ConfigInvasion.firstInvasionNight;
        }
        int dayNumber = (int)(world.func_72820_D() / (long)CoroUtilWorldTime.getDayLength()) + 1;
        int dayStart = dayNumber - dayAdjust;
        if (!ConfigInvasion.invasionCountingPerPlayer && dayStart < 0) {
            return false;
        }
        return (float)dayStart % (float)ConfigInvasion.invadeEveryXDays == 0.0f;
    }

    public static int getInvasionNumber(World world) {
        int dayAdjust = ConfigInvasion.firstInvasionNight;
        int dayNumber = (int)(world.func_72820_D() / (long)CoroUtilWorldTime.getDayLength()) + 1;
        int dayStart = dayNumber - dayAdjust;
        if (dayStart < 0) {
            return 1;
        }
        int invasionNumber = dayStart / ConfigInvasion.invadeEveryXDays;
        return invasionNumber + 1;
    }

    public static DataMobSpawnsTemplate chooseInvasionProfile(EntityPlayer player, DifficultyQueryContext context) {
        ArrayList<DataMobSpawnsTemplate> listPhase2 = new ArrayList<DataMobSpawnsTemplate>();
        InvLog.dbg("choosing invasion profile for player: " + player.func_70005_c_() + ", difficulty: " + context.getDifficulty());
        if (!ConfigCoroUtil.mobSpawnsWaveToForceUse.equals("")) {
            for (DataMobSpawnsTemplate spawns : DifficultyDataReader.getData().listMobSpawnTemplates) {
                if (!spawns.name.equals(ConfigCoroUtil.mobSpawnsWaveToForceUse)) continue;
                return spawns;
            }
            InvLog.err("Couldnt find mob spawn profile: " + ConfigCoroUtil.mobSpawnsWaveToForceUse);
        }
        for (DataMobSpawnsTemplate spawns : DifficultyDataReader.getData().listMobSpawnTemplates) {
            boolean fail = false;
            InvLog.dbg("evaluating conditions for spawn template: " + spawns.toString());
            for (DataCondition condition : DeserializerAllJson.getConditionsFlattened((List)spawns.conditions)) {
                if (condition instanceof ConditionRandom) continue;
                if (!InvasionManager.evaluateCondition(player, condition, context)) {
                    InvLog.dbg("evaluating failed for condition: " + condition + ", dbg: " + condition.toString());
                    fail = true;
                    break;
                }
                InvLog.dbg("evaluating passed for condition: " + condition + ", dbg: " + condition.toString());
            }
            if (fail) continue;
            InvLog.dbg("adding spawn template: " + spawns.name);
            listPhase2.add(spawns);
        }
        int totalWeight = 0;
        ArrayList<Integer> listWeights = new ArrayList<Integer>();
        for (DataMobSpawnsTemplate spawns : listPhase2) {
            int weight = 1;
            for (DataCondition condition : DeserializerAllJson.getConditionsFlattened((List)spawns.conditions)) {
                if (!(condition instanceof ConditionRandom)) continue;
                weight = ((ConditionRandom)condition).weight;
                break;
            }
            listWeights.add(weight);
            totalWeight += weight;
        }
        int index = -1;
        Random rand = new Random();
        if (totalWeight > 0) {
            int randVal = rand.nextInt(totalWeight);
            for (int i = 0; i < listWeights.size(); ++i) {
                if (randVal < (Integer)listWeights.get(i)) {
                    index = i;
                    break;
                }
                randVal -= ((Integer)listWeights.get(i)).intValue();
            }
        }
        if (index != -1) {
            InvLog.dbg("chooseInvasionProfile() for: " + player.func_70005_c_() + ", " + ((DataMobSpawnsTemplate)listPhase2.get(index)).toString());
            return (DataMobSpawnsTemplate)listPhase2.get(index);
        }
        InvLog.dbg("chooseInvasionProfile() returned no invasion profile for: " + player.func_70005_c_());
        return null;
    }

    public static boolean evaluateCondition(EntityPlayer player, DataCondition condition, DifficultyQueryContext context) {
        if (condition instanceof ConditionContext) {
            return context.getContext().equals(((ConditionContext)condition).type);
        }
        if (condition instanceof ConditionDifficulty) {
            return (double)context.getDifficulty() >= ((ConditionDifficulty)condition).min && (double)context.getDifficulty() <= ((ConditionDifficulty)condition).max;
        }
        if (condition instanceof ConditionInvasionNumber) {
            ConditionInvasionNumber condInv = (ConditionInvasionNumber)condition;
            return !(condInv.min != -1 && context.getInvasionNumber() < condInv.min || condInv.max != -1 && context.getInvasionNumber() > condInv.max);
        }
        if (condition instanceof ConditionInvasionRate) {
            return context.getInvasionNumber() % ((ConditionInvasionRate)condition).rate == 0;
        }
        if (condition instanceof ConditionModLoaded) {
            if (((ConditionModLoaded)condition).isInverted()) {
                return !Loader.isModLoaded((String)((ConditionModLoaded)condition).mod_id);
            }
            return Loader.isModLoaded((String)((ConditionModLoaded)condition).mod_id);
        }
        if (condition instanceof ConditionGameStages) {
            return CoroUtilCrossMod.gameStages_hasStages((EntityPlayer)player, (List)((ConditionGameStages)condition).game_stages, (boolean)((ConditionGameStages)condition).matchAll());
        }
        return false;
    }

    public static boolean isAnyoneBeingInvadedTonight(World world) {
        boolean foundNotSkipping = false;
        for (EntityPlayer player : world.field_73010_i) {
            if (InvasionManager.isPlayerSkippingInvasion(player)) continue;
            foundNotSkipping = true;
            break;
        }
        return foundNotSkipping;
    }

    public static boolean isPlayerSkippingInvasion(EntityPlayer player) {
        return player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkipping) || player.getEntityData().func_74767_n(DynamicDifficulty.dataPlayerInvasionSkippingTooSoon);
    }

    public static boolean shouldLockOutFeaturesForPossibleActiveInvasion(World world) {
        return CoroUtilWorldTime.isNightPadded((World)world) && InvasionManager.isInvasionTonight(world) && InvasionManager.isAnyoneBeingInvadedTonight(world);
    }
}

