/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.ambience.client.ambience;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import svenhjol.charm.Charm;
import svenhjol.charmonium.Charmonium;
import svenhjol.charmonium.ambience.client.ambience.BaseAmbientSounds;
import svenhjol.charmonium.base.CharmoniumSounds;
import svenhjol.meson.helper.WorldHelper;

public class CaveAmbientSounds
extends BaseAmbientSounds {
    public CaveAmbientSounds(PlayerEntity player, SoundHandler soundHandler) {
        super(player, soundHandler);
    }

    public static boolean isValidCave(ClientWorld world, PlayerEntity player) {
        if (world == null || world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        if (player.func_204231_K()) {
            return false;
        }
        BlockPos pos = player.func_180425_c();
        int light = world.func_201696_r(pos);
        if (!WorldHelper.canSeeSky((IWorld)world, (BlockPos)pos) && pos.func_177956_o() <= world.func_181545_F()) {
            return pos.func_177956_o() <= 44 || light <= 12;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return CaveAmbientSounds.isValidCave(this.world, this.player);
    }

    @Override
    public int getShortSoundDelay() {
        return this.world.field_73012_v.nextInt(300) + 600;
    }

    @Override
    public float getLongSoundVolume() {
        return 0.35f;
    }

    @Override
    @Nullable
    public SoundEvent getLongSound() {
        return CharmoniumSounds.AMBIENCE_CAVE_LONG;
    }

    @Override
    @Nullable
    public SoundEvent getShortSound() {
        return CharmoniumSounds.AMBIENCE_CAVE_SHORT;
    }

    public static class CrystalCaves
    extends BaseAmbientSounds {
        protected int delay = 0;
        protected boolean eagerCheck = true;

        public CrystalCaves(PlayerEntity player, SoundHandler soundHandler) {
            super(player, soundHandler);
        }

        @Override
        public int getShortSoundDelay() {
            if (this.eagerCheck) {
                Charmonium.LOG.debug("[CrystalCaves] eagerly checking");
                this.delay = this.world.field_73012_v.nextInt(100) + 120;
            } else {
                this.delay = 400;
            }
            return this.delay;
        }

        @Override
        public boolean isValid() {
            return CaveAmbientSounds.isValidCave(this.world, this.player);
        }

        @Override
        @Nullable
        public SoundEvent getLongSound() {
            return null;
        }

        @Override
        protected void setShortSound() {
            BlockPos pos = this.player.func_180425_c();
            int range = 16;
            Stream inRange = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
            List blocks = inRange.map(BlockPos::func_185334_h).collect(Collectors.toList());
            for (BlockPos pp : blocks) {
                if (Charm.quarkCompat == null || !Charm.quarkCompat.isCrystal((World)this.world, pp)) continue;
                super.setShortSound();
                this.eagerCheck = true;
                return;
            }
            this.eagerCheck = false;
        }

        @Override
        @Nullable
        public SoundEvent getShortSound() {
            return CharmoniumSounds.AMBIENCE_CRYSTALS_SHORT;
        }
    }
}

