/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.ambience.client.ambience;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import svenhjol.charmonium.ambience.client.LongSound;
import svenhjol.charmonium.ambience.client.ShortSound;
import svenhjol.charmonium.ambience.client.iface.IAmbientSounds;
import svenhjol.charmonium.ambience.module.Sounds;

public abstract class BaseAmbientSounds
implements IAmbientSounds {
    protected int shortTicks = 0;
    protected boolean isValid = false;
    protected TickableSound longSound = null;
    protected final PlayerEntity player;
    protected final ClientWorld world;
    protected final SoundHandler soundHandler;

    public BaseAmbientSounds(PlayerEntity player, SoundHandler soundHandler) {
        this.player = player;
        this.soundHandler = soundHandler;
        this.world = (ClientWorld)player.field_70170_p;
    }

    public void tick() {
        boolean nowValid = this.isValid();
        if (this.isValid && !nowValid) {
            this.isValid = false;
        }
        if (!this.isValid && nowValid) {
            this.isValid = true;
            this.shortTicks = this.getShortSoundDelay();
        }
        if (nowValid && this.hasShortSound() && --this.shortTicks <= 0) {
            this.setShortSound();
            this.shortTicks = this.getShortSoundDelay();
        }
        if (this.isValid && this.hasLongSound() && !this.isPlayingLongSound()) {
            this.setLongSound();
            this.soundHandler.func_147682_a((ISound)this.longSound);
        }
    }

    public boolean isOutside() {
        if (this.player.func_204231_K()) {
            return false;
        }
        int blocks = 16;
        int start = 1;
        BlockPos playerPos = this.player.func_180425_c();
        for (int i = start; i < start + blocks; ++i) {
            BlockPos check = new BlockPos(playerPos.func_177958_n(), playerPos.func_177956_o() + i, playerPos.func_177952_p());
            BlockState state = this.world.func_180495_p(check);
            Block block = state.func_177230_c();
            if (this.world.func_175710_j(check)) {
                return true;
            }
            if (this.world.func_175623_d(check) || state.func_185904_a() == Material.field_151592_s || block instanceof LogBlock || block instanceof MushroomBlock || block instanceof HugeMushroomBlock || !state.func_200132_m()) continue;
            return false;
        }
        return this.player.func_180425_c().func_177956_o() >= 48;
    }

    protected void setShortSound() {
        this.soundHandler.func_147682_a((ISound)new ShortSound((ClientPlayerEntity)this.player, this.getShortSound(), this.getShortSoundVolume() * (float)Sounds.volumeMultiplier));
    }

    protected void setLongSound() {
        this.longSound = new LongSound(this.player, this.getLongSound(), this.getLongSoundVolume() * (float)Sounds.volumeMultiplier, p -> this.isValid());
    }

    public boolean isPlayingLongSound() {
        return this.longSound != null && !this.longSound.func_147667_k();
    }

    public float getShortSoundVolume() {
        return 0.4f;
    }

    public float getLongSoundVolume() {
        return 0.3f;
    }

    public int getShortSoundDelay() {
        return this.world.field_73012_v.nextInt(400) + 400;
    }

    public boolean hasLongSound() {
        return this.getLongSound() != null;
    }

    public boolean hasShortSound() {
        return this.getShortSound() != null;
    }

    @Override
    public ClientWorld getWorld() {
        return this.world;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public SoundHandler getSoundHandler() {
        return this.soundHandler;
    }
}

