/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.world.feature;

import com.legacy.nethercraft.block.NetherBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class GlowoodTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState DEFAULT_TRUNK = NetherBlocks.glowood_log.func_176223_P();
    private static final BlockState DEFAULT_LEAF = NetherBlocks.glowood_leaves.func_176223_P();
    protected final int minTreeHeight;
    private final BlockState trunk;
    private final BlockState leaf;

    public GlowoodTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace) {
        this(configFactoryIn, doBlockNotifyOnPlace, 4, DEFAULT_TRUNK, DEFAULT_LEAF);
    }

    public GlowoodTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, int minTreeHeightIn, BlockState trunkState, BlockState leafState) {
        super(configFactoryIn);
        this.minTreeHeight = minTreeHeightIn;
        this.trunk = trunkState;
        this.leaf = leafState;
    }

    protected int getHeight(Random random) {
        return this.minTreeHeight + random.nextInt(3);
    }

    protected boolean func_225557_a_(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> set1, Set<BlockPos> set2, MutableBoundingBox box, TreeFeatureConfig config) {
        int i = this.getHeight(rand);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (GlowoodTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$Mutable.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (worldIn.func_217375_a(position, state -> state.func_196958_f()) && GlowoodTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)((IPlantable)NetherBlocks.glowood_sapling)) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int l2 = position.func_177956_o() - 3 + i; l2 <= position.func_177956_o() + i; ++l2) {
                    int l3 = l2 - (position.func_177956_o() + i);
                    int j4 = 1 - l3 / 2;
                    for (int j1 = position.func_177958_n() - j4; j1 <= position.func_177958_n() + j4; ++j1) {
                        int k1 = j1 - position.func_177958_n();
                        for (int l1 = position.func_177952_p() - j4; l1 <= position.func_177952_p() + j4; ++l1) {
                            BlockPos blockpos;
                            int i2 = l1 - position.func_177952_p();
                            if (Math.abs(k1) == j4 && Math.abs(i2) == j4 && (rand.nextInt(2) == 0 || l3 == 0) || !GlowoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(j1, l2, l1))) && !GlowoodTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                            this.func_227217_a_((IWorldWriter)worldIn, blockpos, this.leaf, box);
                        }
                    }
                }
                for (int i3 = 0; i3 < i; ++i3) {
                    if (!GlowoodTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3)) && !GlowoodTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3))) continue;
                    this.func_227217_a_((IWorldWriter)worldIn, position.func_177981_b(i3), this.trunk, box);
                    set1.add(position.func_177981_b(i3).func_185334_h());
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

