/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.item.util;

import com.legacy.nethercraft.item.NetherItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class NeridiumBucketItem
extends Item {
    private final Fluid containedBlock;
    private final Supplier<? extends Fluid> fluidSupplier;

    public NeridiumBucketItem(Fluid containedFluidIn, Item.Properties builder) {
        super(builder);
        this.containedBlock = containedFluidIn;
        this.fluidSupplier = containedFluidIn.delegate;
    }

    public NeridiumBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.containedBlock = null;
        this.fluidSupplier = supplier;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = NeridiumBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.containedBlock == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            BlockPos blockpos1;
            if (this.containedBlock == Fluids.field_204541_a) {
                Fluid fluid;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_177230_c() instanceof IBucketPickupHandler && blockstate1.func_177230_c() == Blocks.field_150353_l && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) == Fluids.field_204547_b) {
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = this.containedBlock.getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack itemstack1 = this.fillBucket(itemstack, playerIn, NetherItems.neridium_lava_bucket);
                    if (!worldIn.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)fluid.func_204524_b()));
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack1);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockPos = blockpos1 = blockstate.func_177230_c() instanceof ILiquidContainer && this.containedBlock == Fluids.field_204546_a ? blockpos : blockraytraceresult.func_216350_a().func_177972_a(blockraytraceresult.func_216354_b());
            if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos1, blockraytraceresult)) {
                this.onLiquidPlaced(worldIn, itemstack, blockpos1);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos1, itemstack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return new ActionResult(ActionResultType.SUCCESS, (Object)this.emptyBucket(itemstack, playerIn));
            }
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    protected ItemStack emptyBucket(ItemStack p_203790_1_, PlayerEntity p_203790_2_) {
        return !p_203790_2_.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)NetherItems.neridium_bucket) : p_203790_1_;
    }

    public void onLiquidPlaced(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, PlayerEntity player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190926_b()) {
            return new ItemStack((IItemProvider)fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)fullBucket))) {
            player.func_71019_a(new ItemStack((IItemProvider)fullBucket), false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult p_180616_4_) {
        if (!(this.containedBlock instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = material.func_76222_j();
        if (worldIn.func_175623_d(posIn) || flag || flag1 || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.containedBlock)) {
            if (worldIn.field_73011_w.func_177500_n() && this.containedBlock.func_207185_a(FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && this.containedBlock == Fluids.field_204546_a) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)this.containedBlock).func_207204_a(false))) {
                    this.playEmptySound(player, (IWorld)worldIn, posIn);
                }
            } else {
                if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.playEmptySound(player, (IWorld)worldIn, posIn);
                worldIn.func_180501_a(posIn, this.containedBlock.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return p_180616_4_ == null ? false : this.tryPlaceContainedLiquid(player, worldIn, p_180616_4_.func_216350_a().func_177972_a(p_180616_4_.func_216354_b()), null);
    }

    protected void playEmptySound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        SoundEvent soundevent = this.containedBlock.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = this.containedBlock.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (((Object)((Object)this)).getClass() == NeridiumBucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }
}

