/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.nethercraft.client.render.entity;

import com.legacy.nethercraft.Nethercraft;
import com.legacy.nethercraft.entity.misc.NetherPaintingEntity;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NetherPaintingRenderer
extends EntityRenderer<NetherPaintingEntity> {
    public NetherPaintingRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(NetherPaintingEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.enableRescaleNormal();
        this.func_180548_c((Entity)entity);
        PaintingType paintingtype = entity.field_70522_e;
        GlStateManager.scalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        PaintingSpriteUploader paintingspriteuploader = Minecraft.func_71410_x().func_213263_ao();
        this.func_217762_a(entity, paintingtype.func_200834_b(), paintingtype.func_200832_c(), paintingspriteuploader.func_215285_a(paintingtype), paintingspriteuploader.func_215286_b());
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(NetherPaintingEntity entity) {
        return Nethercraft.locate("textures/entity/nether_paintings.png");
    }

    private void func_217762_a(NetherPaintingEntity p_217762_1_, int p_217762_2_, int p_217762_3_, TextureAtlasSprite p_217762_4_, TextureAtlasSprite p_217762_5_) {
        float f = (float)(-p_217762_2_) / 2.0f;
        float f1 = (float)(-p_217762_3_) / 2.0f;
        float f3 = p_217762_5_.func_94209_e();
        float f4 = p_217762_5_.func_94212_f();
        float f5 = p_217762_5_.func_94206_g();
        float f6 = p_217762_5_.func_94210_h();
        float f7 = p_217762_5_.func_94209_e();
        float f8 = p_217762_5_.func_94212_f();
        float f9 = p_217762_5_.func_94206_g();
        float f10 = p_217762_5_.func_94207_b(1.0);
        float f11 = p_217762_5_.func_94209_e();
        float f12 = p_217762_5_.func_94214_a(1.0);
        float f13 = p_217762_5_.func_94206_g();
        float f14 = p_217762_5_.func_94210_h();
        int i = p_217762_2_ / 16;
        int j = p_217762_3_ / 16;
        double d0 = 16.0 / (double)i;
        double d1 = 16.0 / (double)j;
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                float f15 = f + (float)((k + 1) * 16);
                float f16 = f + (float)(k * 16);
                float f17 = f1 + (float)((l + 1) * 16);
                float f18 = f1 + (float)(l * 16);
                this.setLightmap(p_217762_1_, (f15 + f16) / 2.0f, (f17 + f18) / 2.0f);
                float f19 = p_217762_4_.func_94214_a(d0 * (double)(i - k));
                float f20 = p_217762_4_.func_94214_a(d0 * (double)(i - (k + 1)));
                float f21 = p_217762_4_.func_94207_b(d1 * (double)(j - l));
                float f22 = p_217762_4_.func_94207_b(d1 * (double)(j - (l + 1)));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                bufferbuilder.func_181662_b((double)f15, (double)f18, -0.5).func_187315_a((double)f20, (double)f21).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, -0.5).func_187315_a((double)f19, (double)f21).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, -0.5).func_187315_a((double)f19, (double)f22).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, -0.5).func_187315_a((double)f20, (double)f22).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, 0.5).func_187315_a((double)f3, (double)f5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, 0.5).func_187315_a((double)f4, (double)f5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, 0.5).func_187315_a((double)f4, (double)f6).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f18, 0.5).func_187315_a((double)f3, (double)f6).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, -0.5).func_187315_a((double)f7, (double)f9).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, -0.5).func_187315_a((double)f8, (double)f9).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, 0.5).func_187315_a((double)f8, (double)f10).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, 0.5).func_187315_a((double)f7, (double)f10).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f18, 0.5).func_187315_a((double)f7, (double)f9).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, 0.5).func_187315_a((double)f8, (double)f9).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, -0.5).func_187315_a((double)f8, (double)f10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f18, -0.5).func_187315_a((double)f7, (double)f10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, 0.5).func_187315_a((double)f12, (double)f13).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f18, 0.5).func_187315_a((double)f12, (double)f14).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f18, -0.5).func_187315_a((double)f11, (double)f14).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f15, (double)f17, -0.5).func_187315_a((double)f11, (double)f13).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, -0.5).func_187315_a((double)f12, (double)f13).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, -0.5).func_187315_a((double)f12, (double)f14).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f18, 0.5).func_187315_a((double)f11, (double)f14).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)f16, (double)f17, 0.5).func_187315_a((double)f11, (double)f13).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    private void setLightmap(NetherPaintingEntity painting, float p_77008_2_, float p_77008_3_) {
        int i = MathHelper.func_76128_c((double)painting.field_70165_t);
        int j = MathHelper.func_76128_c((double)(painting.field_70163_u + (double)(p_77008_3_ / 16.0f)));
        int k = MathHelper.func_76128_c((double)painting.field_70161_v);
        Direction direction = painting.func_174811_aO();
        if (direction == Direction.NORTH) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t + (double)(p_77008_2_ / 16.0f)));
        }
        if (direction == Direction.WEST) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v - (double)(p_77008_2_ / 16.0f)));
        }
        if (direction == Direction.SOUTH) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t - (double)(p_77008_2_ / 16.0f)));
        }
        if (direction == Direction.EAST) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v + (double)(p_77008_2_ / 16.0f)));
        }
        int l = this.field_76990_c.field_78722_g.func_217338_b(new BlockPos(i, j, k), 0);
        int i1 = l % 65536;
        int j1 = l / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)i1, (float)j1);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

